<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Etiketten</title>

    <style>
        /* Basic PDF Setup */
        @page {
            size: A4;
            margin: 0;
        }

        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            display: block;
        }

        .page {
            width: auto;
            height: 275mm;
            margin: 0;
            padding: 5mm;
            box-sizing: border-box;
        }

        .label-grid {
            padding-left: 50px;
            width: 81%;
            height: 80%;
            border-collapse: collapse;
            table-layout: fixed;
        }

        .label-cell {
            width: 50%;
            height: 30mm;
            /* (297mm - 20mm margin) / 8 rows */
            padding-top: 8px;
            padding-bottom: 8px;
            padding-left: 20px;
            padding-right: 20px;
            vertical-align: top;
        }
    </style>

</head>

<body>
    @foreach ($articles->chunk(16) as $chunk)
        <div class="page">
            <table class="label-grid">
                @foreach ($chunk->chunk(2) as $row)
                    <tr>
                        @foreach ($row as $article)
                            <td class="label-cell">
                                <x-pdf.label :article="$article" />
                            </td>
                        @endforeach

                        {{-- Fill empty cell if row has only 1 item --}}
                        @if ($row->count() == 1)
                            <td class="label-cell"></td>
                        @endif
                    </tr>
                @endforeach
            </table>
        </div>
    @endforeach
</body>

</html>
