<?php
// Including all required classes
require_once('class/BCGFontFile.php');
require_once('class/BCGColor.php');
require_once('class/BCGDrawing.php');

// Including the barcode technology
//require_once('class/BCGcode39.barcode.php');
require_once('class/BCGean13.barcode.php');

// Loading Font
//$font = new BCGFontFile('./font/Arial.ttf', 18);
$fontPath = __DIR__ . '/font/Arial.ttf';
if (!file_exists($fontPath)) {
    // If font is missing, stop and show a readable error instead of broken image data
    die("Error: Font file not found at: " . $fontPath . ". Please ensure Arial.ttf is in the 'font' folder.");
}
$font = new BCGFontFile($fontPath, 18);

//versuch code größe zu verändern
//$font = new BCGFontFile('./font/Arial.ttf', 9);

// Don't forget to sanitize user inputs
$text = isset($_GET['text']) ? $_GET['text'] : '2013000000022';

// The arguments are R, G, B for color.
$color_black = new BCGColor(0, 0, 0);
$color_white = new BCGColor(255, 255, 255);

$drawException = null;
try {
	$code = new BCGean13();
	$code->setScale(2); // Resolution
	$code->setThickness(30); // Thickness
	$code->setForegroundColor($color_black); // Color of bars
	$code->setBackgroundColor($color_white); // Color of spaces
	$code->setFont($font); // Font (or 0)
	$code->parse($text); // Text
    
    //versuch code größe zu verändern
    //$code->setScale(1);
    $code->setThickness(20); // Thickness
    $code->clearLabels();
    
} catch(Exception $exception) {
	$drawException = $exception;
}

/* Here is the list of the arguments
1 - Filename (empty : display on screen)
2 - Background color */
$drawing = new BCGDrawing('', $color_white);
if($drawException) {
	$drawing->drawException($drawException);
} else {
	$drawing->setBarcode($code);
    
    //versuche barcode zu drehen
    //$drawing->setRotationAngle(270);
    
	$drawing->draw();
}

// Header that says it is an image (remove it if you save the barcode to a file)
header('Content-Type: image/png');
header('Content-Disposition: inline; filename="barcode.png"');

// Draw (or save) the image into PNG format.
$drawing->finish(BCGDrawing::IMG_FORMAT_PNG);
?>