<?php

class ArtikelController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			/*array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),*/
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions'=>array('create','update','admin','print','genartnr','test','printkunde','etikettendruck','deleteimage','changeimage','mobile'),
                'users'=>array('*'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions'=>array('changepreis','delete'),
                'users'=>array('admin'),
            ),
			array('deny',  // deny all users
                'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->redirect(array('admin'));  
        //$this->render('view',array('model'=>$this->loadModel($id),));
	}
    
    /**
    * Für actionCreate erzeuge eigene Artikelnummer und leite an create weiter
    */
    public function actionGenartnr($kundennr=null)
    {
        //$generated_artikelnr=Artikel::model()->getAutoArtikelNr();
        //$this->render('create',array('model'=>$model,'genartnr'=>$generated_artikelnr));  
        $this->redirect(array('create','genartnr'=>true,'KundenNr'=>$kundennr)); 
    }
    
    
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
     * @param mixed $genartnr - wenn true dann wird artikelnummer vom system generiert und an view in $genartnr zurückgegeben
	 */
	public function actionCreate($genartnr=null)
	{
		//TODO: changelog on newly created artikel missing
        
        $model=new Artikel;

        // Uncomment the following line if AJAX validation is needed,
        $this->performAjaxValidation($model);
        
		if(isset($_POST['Artikel']))
		{
			//komische strings ausfiltern und dadurch diverse angriffe unterbinden
            $_POST['Artikel']=Helper::cleanAllInputData($_POST['Artikel']);
            //initialisieren der standardwerte etc
            $_POST['Artikel']=Artikel::model()->manipulateArtikelData($_POST['Artikel']);
            
            //wenn artikelnummer 13stellig -> dann annahme es ist ein barcode und artikelnummer extrahieren
            if(isset($_POST['Artikel']['ArtikelNr']))
            {
                $_POST['Artikel']['ArtikelNr']=Verkauf::convertBarcodeToArtikelnr($_POST['Artikel']['ArtikelNr']);
            }
            //setze erfrassungszeitstempel
            $model->ErfassungTS=date("Y-m-d H:i:s");
            
            //schreibe änderungslog wenn sich mindestens ein feld verändert hat
            $model->writeChangeLog($_POST['Artikel']['ArtikelNr']);
            
            $model->attributes=$_POST['Artikel'];
            

			if($model->save())
            {
                //$this->redirect(array('view','id'=>$model->ID));
				
                //wenn eine Kundennummer übergeben wurde dann leite wieder auf diese um
                if(isset($_GET["KundenNr"]) && $_GET["KundenNr"]!="")
                {
                    //entferne alles ausser zahlken aus der nummer und versuche kundenmodell zu loaden
                    $_GET["KundenNr"] = preg_replace('![^0-9]!', '', $_GET["KundenNr"]);
                    $this->redirect(array('create','KundenNr'=>$_GET["KundenNr"])); 
                }
                else
                {
                    $this->redirect(array('create'));
                }
            }
		}

        //systemgenerierte artikelnummer an view übergeben
        if(isset($genartnr) && $genartnr==true)
        {
            $generated_artikelnr=Artikel::model()->getAutoArtikelNr();
            $this->render('create',array('model'=>$model,'genartnr'=>$generated_artikelnr));  
        }
        else //default aufruf
        {
		    $this->render('create',array('model'=>$model,'genartnr'=>null));
        }
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Artikel']))
		{
			//komische strings ausfiltern und dadurch diverse angriffe unterbinden
            $_POST['Artikel']=Helper::cleanAllInputData($_POST['Artikel']);
            //preis und initialwerte verarbeiten
            $_POST['Artikel']=Artikel::model()->manipulateArtikelData($_POST['Artikel']);
            
            
            $model->attributes=$_POST['Artikel'];
            
            
            $the_image = CUploadedFile::getInstance($model,'Image');
            if (is_object($the_image) && get_class($the_image)==='CUploadedFile')
            {
                $model->Image= $the_image;
            }
                
            //schreibe änderungslog wenn sich mindestens ein feld verändert hat
            $model->writeChangeLog($id);
            
			if($model->save())
            {
                
                if(is_object($the_image))
                {
                    $model->Image->saveAs(Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image);
                    
                    //nach speicherm des bildes pfad ändern und nochmals speichern um überschreiben der bilder zu verhindern
                    $full_path_old= Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image;
                    $new_file_name=pathinfo ( $model->Image , PATHINFO_FILENAME  )."_".date("dHis").".".pathinfo ( $model->Image , PATHINFO_EXTENSION  );
                    $full_path_new= Yii::getPathOfAlias('webroot').'/images/upload/' .$new_file_name; 
                    
                    copy($full_path_old,$full_path_new);
                    $model->Image= $new_file_name;
                    $_POST['Artikel']['Image']=$new_file_name;
                    $model->writeChangeLog($id);
                    $model->save();
                    unlink($full_path_old);
                    
                }
                
                //$this->redirect(array('view','id'=>$model->ArtikelNr));
                $this->redirect(array('admin'));    
            }
				
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
        /*$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin')); */
            
        //only called from artikel update
        $model=$this->loadModel($id);
        
        //TODO: changelog not working
        $model->writeChangeLogText($id,"Artikel deleted");
        $model->delete();
        
        //wird nur aus update aufgerufen, deshalb gehe nach update zurück
        $this->redirect(array('admin'));
	}
    
    /**
    * Löscht das Image aus DB und File von der jeweiligen ArtikelNr
    * @param mixed $id  - ArtikelNr
    */
    public function actionDeleteimage($id)
    {
        $model=$this->loadModel($id);
        //write changelog
        //TODO: changelog not working
        $model->writeChangeLogText($id,"Picture deleted");
        
        if($model->Image!=null && file_exists(Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image))
        {
            rename(Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image,Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image."_m-id_".$id."_deleted_".date("YmdHis"));
            //unlink(Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image);       
        }
        $model->Image=null;
        $model->save();
        
        
        //wird nur aus update aufgerufen, deshalb gehe nach update zurück
        $this->redirect(array('update','id'=>$id)); 
    }
    

    /**
    * Backend zu Mobile view wenn neues Bild geschickt wird
    * 
    * @param mixed $id
    * @param mixed $path
    */
    public function actionChangeimage()
    {
         //see also http://www.yiiplayground.com/index.php?r=AjaxModule/ajax/ajaxRequest

        //echo "<pre>".print_r($_POST, true)."</pre>";
        //echo "<pre>".print_r($_FILES, true)."</pre>";
        
        //ermittle artikelnummer
        $artnr="";
        if(isset($_POST["artnr"]) && (int)$_POST["artnr"]>0)
        {
            $artnr=Verkauf::convertBarcodeToArtikelnr((int)$_POST["artnr"]);
        }
        else
        {
            echo 'Bitte ArtikelNr eingeben!!';
            Yii::app()->end();
        }
        
        $model = Artikel::model()->find('ArtikelNr = :ArtikelNr', array(':ArtikelNr' => $artnr));
        
        if(!empty($model))
        {
   
            if($_FILES['file']['name'] != '')
            {
                $temp_file=$_FILES['file']['tmp_name'];
                $file_size=$_FILES['file']['size'];
                $orig_file_name=$_FILES['file']['name'];
                $new_file_name=pathinfo ( preg_replace('/[^0-9a-zA-Z_]/',"_",$orig_file_name) , PATHINFO_FILENAME  )."_".date("dHis").".".pathinfo ( $orig_file_name , PATHINFO_EXTENSION  );
                $full_path_new= Yii::getPathOfAlias('webroot').'/images/upload/' .$new_file_name; 
                move_uploaded_file($temp_file, $full_path_new);

                $model->Image= $new_file_name;
                $_POST['Artikel']['Image']=$new_file_name;
                $model->writeChangeLog($artnr);
                $model->save();
                
                //resize image now to save speed on verkauf page and display conversion time
                $imghtml=Yii::app()->easyImage->thumbOf($full_path_new, array('resize' => array('width' => 350),));
                

            
                echo "Nr: ".$artnr." Name:".$model->Name." hat nun Bild ".$orig_file_name." mit ".number_format($file_size / 1048576, 2) . ' MB)<br>';
                Yii::app()->end();
            }
            else
            {
                echo 'Bild ist nicht angekommen.';
                Yii::app()->end();    
            }
            
            Yii::app()->end();       
        }
        else
        {
            echo 'ArtikelNr: '.$artnr.' nicht gefunden!!';
            Yii::app()->end();    
        }
        
        
        

        /*if($_FILES['file']['name'] != ''){
            $test = explode('.', $_FILES['file']['name']);
            $extension = end($test);    
            $name = date("YmdHis")."_".$artnr."_".'.'.$extension;

            $location = 'uploads/'.$name;
            move_uploaded_file($_FILES['file']['tmp_name'], $location);

            echo '<img src="'.$location.'" height="100" width="100" />';
        }*/
        
        
        
        //echo CHtml::encode(print_r($_POST, true));

        //echo "hurra";
        

        /*
        if(isset($_POST["file"]) && isset($_POST["artnr"]))
        {
            echo  $_POST["file"];
        }
        
        $model=$this->loadModel($id);
        
        if($model->Image!=null && file_exists(Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image))
        {
            rename(Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image,Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image."_m-id_".$id."_deleted_".date("YmdHis"));
            //unlink(Yii::getPathOfAlias('webroot').'/images/upload/' . $model->Image);       
        }
        $model->Image=null;
        $model->save();
        
        //wird nur aus update aufgerufen, deshalb gehe nach update zurück
        $this->redirect(array('update','id'=>$id)); */
    }
    
    /**
    * Ändert den Preis nach der Sperre (Aus GUI nur als Admin aufrufbar)
    * @param mixed $id  - ArtikelNr
    */
    public function actionChangepreis($id)
    {
        $model=$this->loadModel($id);
        
        //ruft nur selbe gui erneut auf, in gui wird auf user admin oder nicht abgefragt
        $this->redirect(array('update','id'=>$id)); 
    }

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		/*$dataProvider=new CActiveDataProvider('Artikel');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));*/
        
        /*$model=new Artikel('search');
        $model->unsetAttributes();  // clear any default values
        if(isset($_GET['Artikel']))
            $model->attributes=$_GET['Artikel'];

        $this->render('admin',array(
            'model'=>$model,
        ));*/
        $this->redirect(array('admin'));
	}
    
    /**
     * Mobile View
     */
    public function actionMobile()
    {
        //$this->redirect(array('mobile'));
        $this->render('mobile');
        
        /*$model=new Artikel();
        
        //suchparameter eingeben, alles mit Verkauft nein
        $model->unsetAttributes();  // clear any default values
        $model->VerkauftFlag="Nein";
        
        $this->render('mobile',array(
            'model'=>$model,
        )); */ 
    }
    
    /**
     * Druckt eine Liste aller nicht verkauften Artikel
     */
    public function actionPrint()
    {
        $model=new Artikel('searchForPrintListeNichtVerkauft');
        
        //suchparameter eingeben, alles mit Verkauft nein
        $model->unsetAttributes();  // clear any default values
        $model->VerkauftFlag="Nein";
        
        $this->render('print',array(
            'model'=>$model,
        ));
    }
    
    /**
     * Ruft Einstellungs Seite für Etikettendruck auf
     */
    public function actionEtikettendruck()
    {
        if(isset($_GET["call"]) && $_GET["call"]=="print")
        {
            //kein layout anzeigen
            $this->layout = false;
                
            //ermittle die benötigten Daten anhand der checkboxen
            $model=array();
            if(isset($_POST["check-boxes"]) && is_array($_POST["check-boxes"]) && count($_POST["check-boxes"])>0)
            {
                $key_array=array();
                foreach($_POST["check-boxes"] as $id)
                {
                    $id=intval($id);
                    array_push($key_array,$id);
                }
                
                //alle angehakten etiketten
                $model=Artikel::model()->findAllByPk($key_array);
            }
            
            //ermittle infos aus druckformular (anzahl pro seiten, id etc)
            $return_typ="standard";
            $anzahl_pro_blatt=null;
            if(isset($_POST["Druckformular"]) && $_POST["Druckformular"]!="")
            {
                $etiketten_typen=Parameter::model()->getDrucktypen();
                foreach($etiketten_typen as $key=>$typ)
                {
                    if(isset($typ["id"]) && $typ["id"]==$_POST["Druckformular"])
                        $id=$key;
                }
                if(isset($etiketten_typen[$id]["id"]) && $etiketten_typen[$id]["id"]!="")
                    $return_typ=$etiketten_typen[$id]["id"]; 
                if(isset($etiketten_typen[$id]["anzahl"]) && intval($etiketten_typen[$id]["anzahl"])!=0)
                    $anzahl_pro_blatt=(int)$etiketten_typen[$id]["anzahl"];       
            }
                
            //blatt mit leeren etiketten auffüllen
            $anzahl_leere_etiketten=0;
            if(isset($_POST["blatt_auffuellen"]) && $_POST["blatt_auffuellen"]=="on" && $anzahl_pro_blatt!=null)
            {
                $bestehende_etiketten_modell=(int)count($model);
                
                //ermittle die etiketten der letzten seite in $anzahl_leere_etiketten
                $rest_anzahl_pro_blatt=$bestehende_etiketten_modell;
                while($rest_anzahl_pro_blatt>$anzahl_pro_blatt)
                    $rest_anzahl_pro_blatt=$bestehende_etiketten_modell-$anzahl_pro_blatt;
                
                $anzahl_leere_etiketten=$anzahl_pro_blatt-$rest_anzahl_pro_blatt;  
            }
            //füge die berechnete anzahl an leeren etiketten an das model an
            if($anzahl_leere_etiketten>0)
            {
                for($x=1;$x<=$anzahl_leere_etiketten;$x++)
                {
                    $leerer_artikel_obj=new Artikel();
                    $leerer_artikel_obj->ArtikelNr=Artikel::model()->getManualArtikelNr();
                    $leerer_artikel_obj->Preis="";
                    $leerer_artikel_obj->Groesse="";
                    $leerer_artikel_obj->Marke="";
                    $leerer_artikel_obj->Name="";
                    $leerer_artikel_obj->RefKundenNr="";
                    $leerer_artikel_obj->ErfassungTS="";
                    $leerer_artikel_obj->HappyHourFlag="";
                    array_push($model,$leerer_artikel_obj);
                }
            }
            
            //zusätzliche leere blätter drucken
            if(isset($_POST["blatt_zusatz"]) && intval($_POST["blatt_zusatz"])>0 && $anzahl_pro_blatt!=null)
            {
                for($x=1;$x<=$anzahl_pro_blatt*intval($_POST["blatt_zusatz"]);$x++)
                {
                    $leerer_artikel_obj=new Artikel();
                    $leerer_artikel_obj->ArtikelNr=Artikel::model()->getManualArtikelNr();
                    $leerer_artikel_obj->Preis="";
                    $leerer_artikel_obj->Groesse="";
                    $leerer_artikel_obj->Marke="";
                    $leerer_artikel_obj->Name="";
                    $leerer_artikel_obj->RefKundenNr="";
                    array_push($model,$leerer_artikel_obj);    
                }
            } 
      
            //umleitung auf etikettendruck seite
            $this->render('etikettendruck',array(
                'model'=>$model,'typ'=>$return_typ,
            ));    
        }
        else
        {
            //zeige etikettendruck auswahl an
            $model=new Artikel();
            $this->render('etikettenauswahl',array(
                'model'=>$model,
            ));    
        }
    }
    
    /**
     * Druckt eine Liste aller nicht verkauften Artikel
     */
    public function actionPrintkunde()
    {
        $model=new Artikel('searchForPrintListeNichtVerkauft');
        
        $model_kunden=Kunden::model()->findAll();
        
        //suchparameter eingeben, alles mit Verkauft nein
        $model->unsetAttributes();  // clear any default values
        $model->VerkauftFlag="Nein";
        
        $this->render('printkunde',array(
            'model'=>$model,'model_kunden'=>$model_kunden,
        ));
    }

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Artikel('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Artikel']))
			$model->attributes=$_GET['Artikel'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Artikel the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Artikel::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Artikel $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='artikel-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
    
    //beispiel von http://www.yiiframework.com/wiki/278/cgridview-render-customized-complex-datacolumns/
    //assume you have generated the Address model with gii too
    protected function getKundenName($data,$row)
    {     
        //wenn kein kunde gesetzt -> null
        if(!isset($data->RefKundenNr) || $data->RefKundenNr=="")
            return null;
        
        $model = Kunden::model()->findByPk($data->RefKundenNr);
     
        //get the view from the address CRUD controller (generated with gii)
        //return $this->renderPartial('../kunden/view',array('model'=>$model),true); //set $return = true, don't display direct
        if(isset($model->Name) && isset($model->KundenNr))
            return (string)$model->Name." (".$model->KundenNr.")";
        else
            return "unbekannt, error?";
    }
    
    /**
    * Liefert den Warengruppennamen zu einer Warengruppenid in einer tabelle
    * 
    * @param mixed $data
    * @param mixed $row
    * @return mixed
    */
    protected function getWarengruppenName($data,$row)
    {     
        //wenn kein wgr gesetzt -> null
        if(!isset($data->RefWarengruppeID))
            return null;
        
        $model = Warengruppe::model()->findByPk($data->RefWarengruppeID);
        if(isset($model->Name) && isset($model->ID))
            return (string)$model->Name." (".$model->ID.")";
        else
            return "";
    }
    

    /**
    * Liefert ein x zurück wenn ein Bild existiert, sonnst nichts
    * 
    * @param mixed $data
    * @param mixed $row
    * @return mixed
    */
    protected function getImageJaNein($data,$row)
    {     
        //wenn kein wgr gesetzt -> null
        if(!isset($data->Image) || $data->Image="")
            return null;
        else
            return "x";
    }
    
    //beispiel von http://www.yiiframework.com/wiki/278/cgridview-render-customized-complex-datacolumns/
    //assume you have generated the Address model with gii too
    /**
    * Liefert Formatierten Preis für Ausdruck
    * 
    * @param mixed $data
    * @param mixed $row
    * @return mixed
    */
    protected function getFormatedPreis($data,$row)
    {     
        if(isset($data->Preis) && $data->Preis!="")
            return number_format ( $data->Preis , 2 , "," , "" )." €";
        else
            return "unbekannt, error?";
    }
}
