<?php

class KundenController extends Controller
{
    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            'postOnly + delete', // we only allow deletion via POST request
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules()
    {
        return array(
            array(
                'allow',  // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view'),
                'users' => array('*'),
            ),
            /*array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),*/
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('printsummulti'),
                'users' => array('admin'),
            ),
            array(
                'allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'create', 'update', 'auszahlungsliste', 'print', 'printsum', 'showsum', 'vorerfassunglist', 'vorerfassungimport'),
                'users' => array('*'),
            ),
            array(
                'deny',  // deny all users
                //'actions'=>array('delete','printsummulti'),
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id)
    {

        //umleiten auf artikel creat maske mit übergabe der kunden_id
        $this->redirect(array('artikel/create', 'KundenNr' => $id));

        /*
        //zuerst artikel speichern
        $model_artikel=new Artikel;
        
        // Uncomment the following line if AJAX validation is needed
        //$this->performAjaxValidation($model_artikel);

        if(isset($_POST['Artikel']))
        {
            //preiseingabe wenn in komma dann mit punkt manipulieren, damit eingabe mit komma und punkt möglich
            if(isset($_POST['Artikel']['Preis']))
                $_POST['Artikel']['Preis']=str_replace(",",".",$_POST['Artikel']['Preis']);
            
            $model_artikel->attributes=$_POST['Artikel'];
            if($model_artikel->save())
            {
                $this->redirect(array('view','id'=>$model->KundenNr));
            }
        }

        //artikel view renbdern
        $this->render('view',array('model'=>$model_artikel));
        $this->render('../artikel/_form',array('model'=>$model_artikel));
        
        //$this->renderPartial('../artikel/create', array('model'=>$model_artikel)); 
        
        
        //dann standard kunden view rendern
        $this->render('view',array('model'=>$this->loadModel($id)));
        */
    }



    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate()
    {
        $model = new Kunden;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Kunden'])) {
            //komische strings ausfiltern und dadurch diverse angriffe unterbinden
            $_POST['Kunden'] = Helper::cleanAllInputData($_POST['Kunden']);

            $model->attributes = $_POST['Kunden'];
            if ($model->save()) {
                //$this->redirect(array('view','id'=>$model->ID));
                //$this->redirect(array('create'));    
                $this->redirect(array('admin'));
            }
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id)
    {
        $model = $this->loadModel($id);

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        if (isset($_POST['Kunden'])) {
            //komische strings ausfiltern und dadurch diverse angriffe unterbinden
            $_POST['Kunden'] = Helper::cleanAllInputData($_POST['Kunden']);

            $model->attributes = $_POST['Kunden'];
            if ($model->save()) {
                //$this->redirect(array('view','id'=>$model->KundenNr));
                $this->redirect(array('admin'));
            }
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Druckt die Annahmeliste für einen Kunden
     * 
     * @param mixed $id
     */
    public function actionPrint($id)
    {
        $model = $this->loadModel($id);

        $this->render('print', array(
            'model' => $model,
        ));
    }

    /**
     * Druckt die Kundenabrechnung (Prozess nur einmal möglich, dananch wird abgerechnet bFlag von Kunden gesetzt)
     * 
     * @param mixed $id
     */
    public function actionPrintsum($id)
    {
        $model = $this->loadModel($id);

        $this->render('printsum', array(
            'model' => $model,
        ));

        //eigenschaften auf Kunde nach rendern ändern damit aufruf nur einmalig möglich
        $model->AbgerechnetTS = date("Y-m-d H:i:s");
        $model->AbgerechnetFlag = "Ja";
        $model->save();
    }


    /**
     * Druckt und rechnet mehrere Kunden auf einmal ab
     * 
     * @param mixed $amount
     */
    public function actionPrintsummulti($amount)
    {
        //KundenIDs aus db auslesen und in array stopfen
        $kunden_ids = Kunden::model()->getNichtAbgerechneteKunden($amount);

        //gehe durch alle Kunden und ermittle daten
        $multi_model = null;
        foreach ($kunden_ids as $kunden_key => $kunden_val) {
            if (isset($kunden_val["KundenNr"]) && $kunden_val["KundenNr"] != "" && (int)$kunden_val["KundenNr"] > 0) {
                $id = (int)$kunden_val["KundenNr"];
                $model = $this->loadModel($id);
                $multi_model[$id] = $model;
                //$model->AbgerechnetTS=date("Y-m-d H:i:s");
                //$model->AbgerechnetFlag="Ja";
                //$model->save();   
            }
        }

        $this->render('printsummulti', array('multi_model' => $multi_model,));

        foreach ($kunden_ids as $kunden_key => $kunden_val) {
            if (isset($kunden_val["KundenNr"]) && $kunden_val["KundenNr"] != "" && (int)$kunden_val["KundenNr"] > 0) {
                $id = (int)$kunden_val["KundenNr"];
                $model = $this->loadModel($id);
                $model->AbgerechnetTS = date("Y-m-d H:i:s");
                $model->AbgerechnetFlag = "Ja";
                $model->save();
            }
        }
    }


    public function actionAuszahlungsliste()
    {
        $sql = "SELECT a.KundenNr,a.Name,a.Telefon,a.AbgerechnetFlag,'' as Betrag,'' as Unterschrift FROM kunden a";
        $sql_count = "Select count(*) from kunden";
        $statistik = new Statistik();
        $dataprovider = $statistik->getGenericDataproviderBySQL($sql, $sql_count, "KundenNr");

        $this->render('printauszahlungsliste', array('dataprovider' => $dataprovider, 'header' => "Auszahlungsliste - Unterschrift pro Kunde"));
    }


    /**
     * Zeigt die Kundenabrechnung (Prozess nur mehrfach möglich)
     * 
     * @param mixed $id
     */
    public function actionShowsum($id)
    {
        $model = $this->loadModel($id);

        $this->render('showsum', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id)
    {
        $this->loadModel($id)->delete();

        // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
        if (!isset($_GET['ajax']))
            $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
    }

    /**
     * Lists all models.
     */
    public function actionIndex()
    {
        /*$dataProvider=new CActiveDataProvider('Kunden');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		)); */
        $this->redirect(array('admin'));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin()
    {
        $model = new Kunden('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Kunden']))
            $model->attributes = $_GET['Kunden'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer $id the ID of the model to be loaded
     * @return Kunden the loaded model
     * @throws CHttpException
     */
    public function loadModel($id)
    {
        $model = Kunden::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param Kunden $model the model to be validated
     */
    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'kunden-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }
    
    //beispiel von http://www.yiiframework.com/wiki/278/cgridview-render-customized-complex-datacolumns/
    //assume you have generated the Address model with gii too
    /**
     * Liefert Formatierten Preis für Ausdruck
     * 
     * @param mixed $data
     * @param mixed $row
     * @return mixed
     */
    protected function getFormatedPreis($data, $row)
    {
        if (isset($data->Preis) && $data->Preis != "")
            return number_format($data->Preis, 2, ",", "") . " €";
        else
            return "unbekannt, error?";
    }

    /**
     * Liefert Formatierten Preis zurück und berücksichtigt ob Verkauft wurde oder nicht und ob in Happy Hour verkauft wurde oder nicht
     * 
     * @param mixed $data
     * @param mixed $row
     * @return mixed
     */
    protected function getFormatedVerkaufsPreis($data, $row)
    {
        if (isset($data->VerkauftFlag) && isset($data->VerkauftRabattProz) && isset($data->Preis)) {
            if ($data->VerkauftFlag == "Ja" && $data->VerkauftRabattProz != "0") {
                $preis = (float)$data->Preis - ((float)$data->Preis * (int)$data->VerkauftRabattProz / 100);
                return number_format($preis, 2, ",", "") . " €";
            } elseif ($data->VerkauftFlag == "Ja") {
                return number_format($data->Preis, 2, ",", "") . " €";
            } else {
                return "0,00€";
            }
        } else {
            return "unbekannt, error?";
        }
    }


    /**
     * Liefert den Warengruppennamen zu einer Warengruppenid in einer tabelle
     * 
     * @param mixed $data
     * @param mixed $row
     * @return mixed
     */
    protected function getWarengruppenName($data, $row)
    {
        $model = Warengruppe::model()->findByPk($data->RefWarengruppeID);
        if (isset($model->Name) && isset($model->ID))
            return (string)$model->Name . " (" . $model->ID . ")";
        else
            return "";
    }

    /**
     * Liefert die Info ob der Kunde bereits importiert wurde
     * 
     * @param mixed $data
     * @param mixed $row
     * @return mixed
     */
    protected function getKundeImportFlag($data, $row = null)
    {
        $model = Kunden::model()->findByAttributes(array('ImportID' => $data["id"]));
        if ($model != null && isset($model->KundenNr)) {
            $sql_anzahl = (int)Yii::app()->db->createCommand("SELECT count(*) as Anzahl  FROM artikel where RefKundenNr=" . $model->KundenNr . "")->queryScalar();
            return (string)"Ja (KundenNr: " . $model->KundenNr . " mit " . $sql_anzahl . " Artikel)";
        } else {
            return "Nein";
        }
    }

    protected function getKundeImported($data, $row): bool
    {
        $model = Kunden::model()->findByAttributes(array('ImportID' => $data["id"]));
        if ($model != null && isset($model->KundenNr)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Zeigt eine liste aller Kunden aus der VorerfassungDB
     */
    public function actionVorerfassunglist()
    {
        $dataprovider = Kunden::model()->getKundenVorerfassung();

        $this->render('vorerfassung', array('dataprovider' => $dataprovider));
    }

    /**
     * Importiert die Kunden und Artikelinfos aus der Vorerfassung
     * @param mixed $id - id des users in der vorerfassungsdb
     */
    public function actionVorerfassungimport($id)
    {
        //sicherstellen, dass id nur nummerisch ist
        $id = intval($id);

        //Kunde importieren
        $KundenNr = Kunden::model()->importKundeVorerfassung($id);

        //nur weiter wenn import erfolgreich
        if ($KundenNr != null) {
            $ArtImport_return = Artikel::model()->importArtikelVorerfassung($id, $KundenNr);
            Yii::app()->user->setFlash('import', 'Import von User aus Vorerfassung in KundeNr:' . $KundenNr . ' OK, Rückmeldung aus Artikelimport: ' . $ArtImport_return);
        } else {
            //meldung an enduser in kunde/admin view, siehe auch: http://www.yiiframework.com/wiki/111/using-setflash-for-displaying-various-kind-of-messages/
            Yii::app()->user->setFlash('import', 'Error bei Import von User aus Vorerfassung in Kunde (ImportID:' . $id . '), kein Artikelimport möglich.');
        }

        //nanch verarbeitung redirekt zum admin
        $this->redirect(array('admin'));
    }
}
