<?php

class ParameterController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','admin'),
				'users'=>array('*'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('create','delete','initdb','update'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->redirect(array('admin'));
        
       /* $this->render('view',array(
			'model'=>$this->loadModel($id),
		));*/
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Parameter;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Parameter']))
		{
			$_POST['Parameter']=Helper::cleanAllInputData($_POST['Parameter']);
            
            $model->attributes=$_POST['Parameter'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->Name));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Parameter']))
		{
			$_POST['Parameter']=Helper::cleanAllInputData($_POST['Parameter']);
            
            $model->attributes=$_POST['Parameter'];
			if($model->save())
				$this->redirect(array('admin'));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}
    
    /**
    * Initialisiere Datenbank
    */
    public function actionInitdb()
    {
        //löschvorgang durchführen und zurück zu parameterliste
        if(isset($_GET["delete"]) && $_GET["delete"]==1)
        {
            //tabelle artikel neu initialisieren
            Yii::app()->db->createCommand("DROP TABLE IF EXISTS artikel")->query();
            $sql="CREATE TABLE IF NOT EXISTS `artikel` (
              `ArtikelNr` bigint(20) NOT NULL,
              `Name` varchar(100) NOT NULL,
              `Preis` float NOT NULL,
              `Kommentar` varchar(300) DEFAULT NULL,
              `RefKundenNr` bigint(20) NOT NULL,
              `VerkauftFlag` varchar(5) NOT NULL DEFAULT 'Nein',
              `VerkauftTS` datetime DEFAULT NULL,
              `ErfassungTS` datetime DEFAULT NULL,
              `Image` varchar(100) DEFAULT NULL,
              `Groesse` varchar(10) DEFAULT NULL,
              `RefWarengruppeID` bigint(20) DEFAULT NULL,
              `Marke` varchar(50) DEFAULT NULL,
              `HappyHourFlag` varchar(5) NOT NULL DEFAULT 'Nein',
              `VerkauftRabattProz` int(11) NOT NULL DEFAULT '0',
              `ImportID` bigint(20) DEFAULT NULL,
              PRIMARY KEY (`ArtikelNr`),
              KEY `RefKundenNr` (`RefKundenNr`),
              KEY `VerkauftFlag` (`VerkauftFlag`),
              KEY `ErfassungsTS` (`ErfassungTS`)
            ) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
        Yii::app()->db->createCommand($sql)->query();
        
        //tabelle artikel änderungslog neu initialisieren
        Yii::app()->db->createCommand("DROP TABLE IF EXISTS artikel_aenderungslog")->query();
        $sql="CREATE TABLE IF NOT EXISTS `artikel_aenderungslog` (
          `ChangeTS` datetime DEFAULT NULL,
          `ChangeIP` varchar(100) DEFAULT NULL,
          `ChangeFields` varchar(300) DEFAULT NULL,
          `ArtikelNr` bigint(20) NOT NULL,
          `Name` varchar(100) DEFAULT NULL,
          `Preis` float DEFAULT NULL,
          `Kommentar` varchar(300) DEFAULT NULL,
          `RefKundenNr` bigint(20) NOT NULL,
          `VerkauftFlag` varchar(5) DEFAULT NULL,
          `VerkauftTS` datetime DEFAULT NULL,
          `ErfassungTS` datetime DEFAULT NULL,
          `Image` varchar(100) DEFAULT NULL,
          `Groesse` varchar(10) DEFAULT NULL,
          `RefWarengruppeID` bigint(20) DEFAULT NULL,
          `Marke` varchar(50) DEFAULT NULL,
          `HappyHourFlag` varchar(5) DEFAULT NULL,
          `VerkauftRabattProz` int(11) DEFAULT NULL,
          `ImportID` bigint(20) NOT NULL,
          KEY `ArtikelNr` (`ArtikelNr`),
          KEY `RefKundenNr` (`RefKundenNr`)
        ) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
        Yii::app()->db->createCommand($sql)->query();
        
        //tabelle artikel_autonrvergabe neu initialisieren
            Yii::app()->db->createCommand("DROP TABLE IF EXISTS artikel_autonummernvergabe")->query();
            $sql="CREATE TABLE IF NOT EXISTS `artikel_autonummernvergabe` (
              `ArtikelNr` bigint(20) NOT NULL,
              `VergabeTS` datetime NOT NULL,
              `VergabeIP` varchar(50) NOT NULL,
              `VergabeTyp` varchar(10) DEFAULT NULL,
              PRIMARY KEY (`ArtikelNr`)
            ) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
        Yii::app()->db->createCommand($sql)->query();
        
        
        //tabelle kunden neu initialisieren
            Yii::app()->db->createCommand("DROP TABLE IF EXISTS kunden")->query();
            $sql="CREATE TABLE IF NOT EXISTS `kunden` (
              `KundenNr` bigint(20) NOT NULL AUTO_INCREMENT,
              `Name` varchar(100) NOT NULL,
              `Telefon` varchar(100) NOT NULL,
              `Email` varchar(300) DEFAULT NULL,
              `PLZ` bigint(20) DEFAULT NULL,
              `Kommentar` varchar(300) DEFAULT NULL,
              `AbgerechnetFlag` varchar(6) NOT NULL DEFAULT 'Nein',
              `AbgerechnetTS` datetime DEFAULT NULL,
              `VerwaltungBezahltFlag` varchar(6) NOT NULL DEFAULT 'Ja',
              `ImportID` bigint(20) DEFAULT NULL,
              PRIMARY KEY (`KundenNr`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
        Yii::app()->db->createCommand($sql)->query();
        
                //tabelle parameter neu initialisieren
            Yii::app()->db->createCommand("DROP TABLE IF EXISTS parameter")->query();
            $sql="CREATE TABLE IF NOT EXISTS `parameter` (
          `Name` varchar(50) NOT NULL,
          `Wert` text NOT NULL,
          `Laenge` int(11) DEFAULT NULL,
          `Typ` varchar(20) DEFAULT NULL,
          `Beschreibung` varchar(300) NOT NULL,
          PRIMARY KEY (`Name`)
        ) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
        Yii::app()->db->createCommand($sql)->query();
        $sql="INSERT INTO `parameter` (`Name`, `Wert`, `Laenge`, `Typ`, `Beschreibung`) VALUES
        ('abrechnung_betrag_verwaltungsaufwand', '0.5', 5, 'float_0-10', 'Wieviel Euro sollen als Verwaltungsaufwand pro Position berechnet werden (Eingabe 0.01=1cent bis 10=10€)'),
        ('abrechnung_disclaimer', 'Mit dieser Unterschrift wird die Abrechnung gültig und kann bei der Kassa eingelöst werden.', 2000, 'text', 'Dieser Text wird in der Kundenabrechnung zwischen der Überschrift Freigabe und dem Unterschriftsfeld dargestellt'),
        ('abrechnung_disclaimer_show', '0', 1, 'bool', 'Soll der Freigabetext auf der Abrechnung des Kunden angezeigt werden. Standardmäßig auf 0=nein gestellt. Andere Möglichkeit ist 1=ja.'),
        ('abrechnung_provision_prozent', '15', 2, 'zahl_1-99', 'Wieviel Prozent sollen in der Abrechnung als Provision einbehalten werden'),
        ('annahmeliste_disclaimer', 'Der Veranstalter übernimmt keine Gewährleistung für die Richtigkeit der Angebotsangaben, die Qualität, Funktions- sowie Gebrauchsfähigkeit der Angebotsgegenstände.\r\nDie TMK-Koppl übt nur eine Vermittlertätigkeit aus. Es kann keine Haftung für Diebstahl, Verlust, Beschädigung oder Größenangaben übernommen werden. <br /><br />Umtausch oder Reklamation ist nicht möglich. Es werden 15% des Verkaufserlöses, sowie 50 Cent für jeden abgegebenen Artikel eingehoben.', 2000, 'text', 'Dieser Text wird in der Annahmeliste zwischen der Überschrift Disclaimer und dem Unterschriftsfeld dargestellt'),
        ('artikel_autonr_ende', '15000', 5, 'ganzzahl', 'Höchste vom System automatisch vergebene Artikelnummer'),
        ('artikel_autonr_start', '7000', 5, 'ganzzahl', 'Niedrigste vom System automatisch vergebene Artikelnr'),
        ('happyhour_anzeigen', 0, 1, 'bool', 'Wenn aktiv=1 dann wird die Hapyhour Information auf dem Annahmeprotokoll angezeigt, bei inaktiv=0 wird sie ausgeblendet'),
        ('artikel_nr_min', '1000', 5, 'ganzzahl', 'Manuell vergebene Artikelnummern starten beim Etikettendruck erst ab diesem Wert. Dadurch wird z.B. sichergestellt, dass vorgedruckte Etiketten aus dem Vorjahr verwendet werden koennen'),
        ('etikett_header', 'Tauschmarkt der TMK-Koppl 2013', 30, 'text', 'Text der in der ersten Zeile am Etikett angezeigt wird'),
        ('etiketten_typen', 'standard_2018,16;', 2000, 'text', 'Hier werden alle zur Auswahl stehenden Etikettentypen definiert im Format nametyp1,AnzahlEtikettenproBlatt;nametyp2,16; und so weiter. Der Name darf nur Buchstaben, Zahlen und _ enthalten und entspricht 1:1 dem Ordnernamen unter _lable_print/formulare'),
        ('happyhour_prozent', '50', 2, 'zahl_1-99', 'Ab dem Happyhour Startzeitpunkt werden alle Artikel wo das HappyHourer Flag gesetzt ist beim Verkauf um diesen Prozentsatz reduziert.'),
        ('happyhour_starttime', '29.11.2013 18:12:00', 19, 'dd.mm.YYYY_HH:mm:ss', 'Ab diesem Zeitpunkt werden die Verkaufe der Artikel für die das HappyHour Flag gesetzt bist um einen entsprechenden prozentsatz beim Verkauf reduziert. Keine Eingaben mit Datum weit in der Zukunft verwenden! (Eingabe z.B. \"01.01.2020 01:12:00\")'),
        ('info_naechste_veranstaltung', '<h3>Weitere Termine:</h3>\r\nVerkauf am Sonntag 10-16 Uhr, <b>Abholung am Sonntag 17-19 Uhr</b>\r\n<br /><br /><b>Nächster Musi Tauschmarkt findet von 27.02.201X bis 29.02.201X statt. Details unter http://meintauschmarkt.at</b>', 2000, 'text', 'Der folgende Infotext wird auf allen Dokumenten die der Kunden mitbekommt angedruckt. Dadurch kann man den Kunden über zukünftige Veranstaltungen informieren. Um keine Information anzuzeigen text löschen.'),
        ('preisaenderung_verboten_ab', '30.11.2013 11:29:00', 19, 'dd.mm.YYYY_HH:mm:ss', 'Ab diesem Zeitpunkt ist eine Preisänderung über Artikel - Ändern nicht mehr möglich. Nur noch der Admin kann einen Preis ändern. Um Prüfung aufzuheben wird Datum gelöscht. Format zB 01.01.2013 23:00:15'),
        ('show_artikelnr_by_system_button', '1', 1, 'bool', 'Zeigt bzw. Versteckt in der Artikelrefassung den Button Artikelnummer-bei-System-generieren. Wird bei vorgedruckten Etiketten nicht benötigt.'),
        ('unterschrift_ort', 'Koppl', 50, 'text', 'Der Folgende Text wird als Ort neben dem Datum bei der Unterschrift angegeben');";
        Yii::app()->db->createCommand($sql)->query();
        
                //tabelle reklamation neu initialisieren
            Yii::app()->db->createCommand("DROP TABLE IF EXISTS reklamation")->query();
            $sql="CREATE TABLE IF NOT EXISTS `reklamation` (
          `ReklamationNr` bigint(20) NOT NULL AUTO_INCREMENT,
          `RefKundenNr` varchar(50) NOT NULL,
          `RefArtikelNr` varchar(50) NOT NULL,
          `Beschwerde` varchar(3000) NOT NULL,
          `AngedachteLoesung` varchar(3000) DEFAULT NULL,
          `Status` varchar(50) DEFAULT NULL,
          `ErfassungTS` datetime DEFAULT NULL,
          PRIMARY KEY (`ReklamationNr`)
        ) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
        Yii::app()->db->createCommand($sql)->query();
            
            //tabelle verkauf neu initialisieren
            Yii::app()->db->createCommand("DROP TABLE IF EXISTS verkauf")->query();
            $sql="CREATE TABLE IF NOT EXISTS `verkauf` (
              `ID` bigint(20) NOT NULL AUTO_INCREMENT,
              `SessionID` varchar(100) NOT NULL,
              `ErfassterBarcode` varchar(50) NOT NULL,
              `RefArtikelNr` bigint(20) DEFAULT NULL,
              `ErfassungTS` datetime NOT NULL,
              `VerkaufErledigt` varchar(5) NOT NULL DEFAULT 'Nein',
              PRIMARY KEY (`ID`),
              KEY `SessionID` (`SessionID`),
              KEY `ErfassungTS` (`ErfassungTS`),
              KEY `VerkaufErledigt` (`VerkaufErledigt`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
        Yii::app()->db->createCommand($sql)->query();
        
        //tabelle warengruppe neu initialsisieren
                    Yii::app()->db->createCommand("DROP TABLE IF EXISTS warengruppe")->query();
            $sql="CREATE TABLE IF NOT EXISTS `warengruppe` (
          `ID` bigint(20) NOT NULL AUTO_INCREMENT,
          `Name` varchar(100) NOT NULL,
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
        Yii::app()->db->createCommand($sql)->query();
            
            //hochgeladene bilder und der thumbnail cache löschen nund verzeichnisse wieder erstellen
            $this->deletedir_recursive(Yii::getPathOfAlias('webroot').'/images/upload/');
            mkdir(Yii::getPathOfAlias('webroot').'/images/upload/');
            $this->deletedir_recursive(Yii::getPathOfAlias('webroot').'/cache/easyimage/');
            mkdir(Yii::getPathOfAlias('webroot').'/cache/easyimage/');
            
            //assets cache löschen
            $this->deletedir_recursive(Yii::getPathOfAlias('webroot').'/assets/');
            mkdir(Yii::getPathOfAlias('webroot').'/assets/');
            
            $this->redirect(array('admin')); 
        }
        else
        {
            //anzeige von löschdialog ja/nein
            $this->render('initdb');      
        } 
    }

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$this->redirect(array('admin'));
        
        /*$dataProvider=new CActiveDataProvider('Parameter');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));*/
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Parameter('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Parameter']))
			$model->attributes=$_GET['Parameter'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Parameter the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Parameter::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Parameter $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='parameter-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
    
    /**
    * Löscht rekursiv ein Verzeichniss
    * @param mixed $dir
    */
    private function deletedir_recursive($dir)
    {
        //input von hier http://www.ulrich-block.de/rekursives-loschen-oder-rm-r-mit-php/
        // Wenn der Input ein Ordner ist, dann Überprüfung des Inhaltes beginnen
        if (is_dir($dir)) {
            // Ordnerinhalt auflisten und jedes Element nacheinander überprüfen
            $dircontent=scandir($dir);
            foreach ($dircontent as $c) {
                // Wenn es sich um einen Ordner handelt, die Funktion rmr(); aufrufen
                if ($c!='.' and $c!='..' and is_dir($dir.DIRECTORY_SEPARATOR.$c)) {
                    $this->deletedir_recursive($dir.DIRECTORY_SEPARATOR.$c);
                // Wenn es eine Datei ist, diese löschen
                } else if ($c!='.' and $c!='..') {
                    if(file_exists($dir.DIRECTORY_SEPARATOR.$c))
                        unlink($dir.DIRECTORY_SEPARATOR.$c);
                }
            }
            // Den nun leeren Ordner löschen
            if(file_exists($dir))
                rmdir($dir);
        // Wenn es sich um eine Datei handelt, diese löschen
        } else {
            if(file_exists($dir))
                unlink($dir);
        }
    }

}
