<?php

class ReklamationController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','admin'),
				'users'=>array('*'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Reklamation;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Reklamation']))
		{
			$_POST['Reklamation']=Helper::cleanAllInputData($_POST['Reklamation']);
            
            $_POST['Reklamation']['ErfassungTS']=date("Y-m-d H:i:s");
            
            $model->attributes=$_POST['Reklamation'];
			if($model->save())
				$this->redirect(array('admin'));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Reklamation']))
		{
			$_POST['Reklamation']=Helper::cleanAllInputData($_POST['Reklamation']);
            
            $model->attributes=$_POST['Reklamation'];
			if($model->save())
				$this->redirect(array('admin'));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Reklamation');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Reklamation('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Reklamation']))
			$model->attributes=$_GET['Reklamation'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Reklamation the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Reklamation::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Reklamation $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='reklamation-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
    
    
    /**
    * Liefert den Artikelnamen zu der ArtikelID
    * 
    * @param mixed $data
    * @param mixed $row
    */
    protected function getArtikelName($data,$row)
    {     
        $model = Artikel::model()->findByPk($data->RefArtikelNr);
        if(isset($model->Name))
        {
            return  $model->Name;
        }
        else
        {
            return "Unbekannt"; 
        }
    }
    
    //beispiel von http://www.yiiframework.com/wiki/278/cgridview-render-customized-complex-datacolumns/
    //assume you have generated the Address model with gii too
    protected function getKundenName($data,$row)
    {     
        $model = Kunden::model()->findByPk($data->RefKundenNr);
     
        //get the view from the address CRUD controller (generated with gii)
        //return $this->renderPartial('../kunden/view',array('model'=>$model),true); //set $return = true, don't display direct
        if(isset($model->Name) && isset($model->KundenNr))
        {
            return (string)$model->Name." (".$model->KundenNr.")";
        }
        else
        {
            return "Unbekannt (".$data->RefKundenNr.")";
        }
    }
    
}
