<?php

class StatistikController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	//public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','admin','update','umsatzliste'),
				'users'=>array('*'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('create','delete','initdb'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
    
    /**
     * Statistik Übersichtsseite
     */
    public function actionIndex()
    {
        $this->render('index');
    }
    
    public function actionUmsatzliste()
    {
        $sql="SELECT a.KundenNr,a.Name,(select count(*) FROM artikel where refkundennr=a.KundenNr and VerkauftFlag='Ja') as verkauft_STK,(select cast(sum(Preis) as dec)  FROM artikel where refkundennr=a.KundenNr and VerkauftFlag='Ja') as verkauft_EUR,(select count(*) FROM artikel where refkundennr=a.KundenNr and VerkauftFlag='Nein') as offen_STK,(select cast(sum(Preis) as dec)  FROM artikel where refkundennr=a.KundenNr and VerkauftFlag='Nein') as offen_EUR FROM kunden a";
        $sql_count="Select count(*) from kunden";
        $statistik = new Statistik();
        $dataprovider=$statistik->getGenericDataproviderBySQL($sql,$sql_count,"KundenNr");
        
        $this->render('generic',array('dataprovider'=>$dataprovider,'header'=>"Umsatzliste per Kunde"));    
        
    }


}
