<?php

class VerkaufController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	//public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request - deaktiviert für get delete request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('*'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'), //delete hier auch erlauben da sätze nicht gelöscht sondern nur der status umgestellt wird
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Verkauf;
        //$temp_ref="";

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Verkauf']) && isset($_POST['Verkauf']['ErfassterBarcode']) && $_POST['Verkauf']['ErfassterBarcode']!="")
		{
			$_POST['Verkauf']=Helper::cleanAllInputData($_POST['Verkauf']);
            
            $model->attributes=$_POST['Verkauf'];
			
            //setze standardwerte und versuche barcode zu ermitteln
            $model->SessionID=Verkauf::model()->getCurrentSessionID();
            $model->ErfassungTS=date("Y-m-d H:i:s");
            $model->RefArtikelNr=Verkauf::model()->searchArtikelNrfromBarcode($model->ErfassterBarcode);
            //beim erneuten abschießen immer wieder auf nein zurücksetzen da nur nein in der liste angezeigt wird
            $model->VerkaufErledigt="Nein";
            
            
            if($model->save())
            {
				$this->redirect(array('create'));
            }
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Verkauf']))
		{
			$_POST['Verkauf']=Helper::cleanAllInputData($_POST['Verkauf']);
            
            $model->attributes=$_POST['Verkauf'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->ID));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}
    
    
    /**
    * Markiert alle Einträge als Verkauft
    * 
    */
    public function actionMarksold()
    {
        //lese alle betroffenen elemente aus der DB
        $sessionid=Verkauf::model()->getCurrentSessionID();
        $list=Verkauf::model()->findAll(array('condition'=>'SessionID=:sessionid AND VerkaufErledigt >= :erledigt','params'=>array(':sessionid'=>$sessionid, ':erledigt'=>"Nein"),));
        
        //gehe über alle objecte und setze VerkaufErledigt auf Ja und Setze Artikel auf Verkauft und VerkauftTS
        foreach($list as $item)
        {
            //aktualisiere verkauf
            $model=null; 
            $model=$this->loadModel($item->ID);
            $model->VerkaufErledigt="Ja";
            $model->save();
            
            //aktualisiere artikel wenn artikelauflösung ok
            if(isset($model->RefArtikelNr) && $model->RefArtikelNr!="" && (int)$model->RefArtikelNr!=0)
            {
                $model_artikel=null;
                $model_artikel=Artikel::model()->findByPk($model->RefArtikelNr);
                if(isset($model_artikel) && $model_artikel!=null)
                {
                    //prüfe ob ein happyhour verkauf vorliegt -> wenn ja eintrag der prozente in artikelstamm
                    $happyhour_preis=Verkauf::calcVerkaufsPreis($model->ErfassungTS,$model->RefArtikelNr,true);
                    $happyhour_prozent=(int)Parameter::model()->findByPk("happyhour_prozent")->Wert; 
                    if((float)$happyhour_preis<(float)$model_artikel->Preis)
                    {
                        $model_artikel->VerkauftRabattProz=$happyhour_prozent;
                    }                                             
                    $model_artikel->VerkauftFlag="Ja";
                    $model_artikel->VerkauftTS=date("Y-m-d H:i:s");
                    
                    //simuliere post daten für logeintrag
                    $_POST['Artikel']=$model_artikel->attributes;
                    //schreibe Logeintrag
                    Artikel::model()->writeChangeLog($model->RefArtikelNr);
                    
                    $model_artikel->save();
                }    
            }
        }    
        
        $this->redirect(array('create'));    
    }

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
        //$this->loadModel($id)->delete();

        //statt löschen den eintrag nur auf einen anderen Status ingor setzen
        $model=$this->loadModel($id);
        $model->VerkaufErledigt="Ignor";
        $model->save();
        
        
		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		//if(!isset($_GET['ajax']))
			//$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        
        //immer nach create zurück springen, egal ob ajax request oder nicht  
        /*$this->render('create',array(
            'model'=>$model,
        ));*/
        $this->redirect(array('create'));   
        
	}
    
    /**
     * Druckt eine Liste aller Verkauften Artikel
     */
    public function actionPrint()
    {
        $model=new Verkauf('searchAllValid');
        
        //suchparameter eingeben, alles mit VerkauftErledigt Ja und wo artikel gefunden wurden
        $model->unsetAttributes();  // clear any default values
        //$model->VerkaufErledigt="Ja";
        
        $this->render('print',array(
            'model'=>$model,
        ));
    }

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		//gehe in die create gui
        $this->redirect(array('create'));   
        
        /*
        $dataProvider=new CActiveDataProvider('Verkauf');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));*/
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Verkauf('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Verkauf']))
			$model->attributes=$_GET['Verkauf'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Verkauf the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Verkauf::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Verkauf $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='verkauf-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
    
    /**
    * Liefert den Artikelnamen zu der ArtikelID
    * 
    * @param mixed $data
    * @param mixed $row
    */
    protected function getArtikelName($data,$row)
    {     
        $model = Artikel::model()->findByPk($data->RefArtikelNr);
        if(isset($model->Name))
        {
            return  $model->Name;
        }
        else
        {
            return  "Nicht gefunden";    
        }
    }
    
    /**
    * Liefert den VerkaufsZeitstempel zu der ArtikelID
    * 
    * @param mixed $data
    * @param mixed $row
    */
    protected function getArtikelVerkauftTS($data,$row)
    {     
        $model = Artikel::model()->findByPk($data->RefArtikelNr);
        if(isset($model->VerkauftTS))
        {
            return  $model->VerkauftTS;
        }
        else
        {
            return  "nein";    
        }
    }
    
    
    
    /**
    * Liefert den tatsächlichen Verkaufspreis inkls berücksichtigung der Happy Hour
    * 
    * @param mixed $data
    * @param mixed $row
    */
    protected function getArtikelVerkaufsPreis($data,$row)
    {     
        return Verkauf::calcVerkaufsPreis($data->ErfassungTS,$data->RefArtikelNr);
    }
    
    /**
    * Liefert den ArtikelPreis zu der ArtikelID
    * 
    * @param mixed $data
    * @param mixed $row
    */
    protected function getArtikelPreis($data,$row)
    {     
        $model = Artikel::model()->findByPk($data->RefArtikelNr);
        if(isset($model->Preis))
        {
            return number_format ( $model->Preis , 2 , "," , "" )." €";
        }
        else
        {
            return  "Nicht gefunden";    
        }
    }
    
    /**
    * Liefert den KundenID zu der ArtikelID
    * 
    * @param mixed $data
    * @param mixed $row
    */
    protected function getArtikelKunde($data,$row)
    {     
        $model = Artikel::model()->findByPk($data->RefArtikelNr);
        if(isset($model->RefKundenNr))
        {
            return $model->RefKundenNr;
        }
        else
        {
            return  "";    
        }
    }
}
