<?php

/**
 * This is the model class for table "artikel_aenderungslog".
 *
 * The followings are the available columns in table 'artikel_aenderungslog':
 * @property string $ChangeTS
 * @property string $ChangeIP
 * @property string $ChangeFields
 * @property string $ArtikelNr
 * @property string $Name
 * @property double $Preis
 * @property string $Kommentar
 * @property string $RefKundenNr
 * @property string $VerkauftFlag
 * @property string $VerkauftTS
 * @property string $ErfassungTS
 * @property string $Image
 * @property string $Groesse
 * @property string $RefWarengruppeID
 * @property string $Marke
 * @property string $HappyHourFlag
 * @property string $VerkauftRabattProz
 * @property string $ImportID
 */
class ArtikelAenderungslog extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'artikel_aenderungslog';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ArtikelNr, RefKundenNr', 'required'),
			array('Preis,VerkauftRabattProz', 'numerical'),
			array('ChangeIP, Name, Image', 'length', 'max'=>100),
			array('ArtikelNr, RefKundenNr, RefWarengruppeID', 'length', 'max'=>20),
			array('Kommentar, ChangeFields', 'length', 'max'=>300),
			array('VerkauftFlag, HappyHourFlag', 'length', 'max'=>5),
			array('Groesse', 'length', 'max'=>10),
			array('Marke', 'length', 'max'=>50),
			array('ChangeTS, VerkauftTS, ErfassungTS', 'safe'),
			// The following rule is used by search().
			
			array('ChangeFields, ChangeTS, ChangeIP, ArtikelNr, Name, Preis, Kommentar, RefKundenNr, VerkauftFlag, VerkauftTS, ErfassungTS, Image, Groesse, RefWarengruppeID, Marke, HappyHourFlag, VerkauftRabattProz, ImportID', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'ChangeTS' => 'Change Ts',
			'ChangeIP' => 'Change Ip',
            'ChangeFields' => 'Change Fields',
			'ArtikelNr' => 'Artikel Nr',
			'Name' => 'Name',
			'Preis' => 'Preis',
			'Kommentar' => 'Kommentar',
			'RefKundenNr' => 'Ref Kunden Nr',
			'VerkauftFlag' => 'Verkauft Flag',
			'VerkauftTS' => 'Verkauft Ts',
			'ErfassungTS' => 'Erfassung Ts',
			'Image' => 'Image',
			'Groesse' => 'Groesse',
			'RefWarengruppeID' => 'Ref Warengruppe',
			'Marke' => 'Marke',
			'HappyHourFlag' => 'Happy Hour Flag',
            'VerkauftRabattProz' => 'Verkauf Reduziert (in %)',
            'ImportID' => 'Import ID'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		
        

		$criteria=new CDbCriteria;

		$criteria->compare('ChangeTS',$this->ChangeTS,true);
        $criteria->compare('ChangeIP',$this->ChangeIP,true);
		$criteria->compare('ChangeFields',$this->ChangeFields,true);
		$criteria->compare('ArtikelNr',$this->ArtikelNr,false); //nur exakt
		$criteria->compare('Name',$this->Name,true);
		$criteria->compare('Preis',$this->Preis, false); //nur exakt
		$criteria->compare('Kommentar',$this->Kommentar,true);
		$criteria->compare('RefKundenNr',$this->RefKundenNr,false);  //nur exakt
		$criteria->compare('VerkauftFlag',$this->VerkauftFlag,true);
		$criteria->compare('VerkauftTS',$this->VerkauftTS,true);
		$criteria->compare('ErfassungTS',$this->ErfassungTS,true);
		$criteria->compare('Image',$this->Image,true);
		$criteria->compare('Groesse',$this->Groesse,true);
		$criteria->compare('RefWarengruppeID',$this->RefWarengruppeID,true);
		$criteria->compare('Marke',$this->Marke,true);
        $criteria->compare('HappyHourFlag',$this->HappyHourFlag,true);
        $criteria->compare('VerkauftRabattProz',$this->VerkauftRabattProz,false);  //nur exakt
		$criteria->compare('ImportID',$this->ImportID,false);  //nur exakt

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
            'pagination'=>array('pageSize'=>1000,), //1000 pro seite
            'sort'=>array(
                'defaultOrder'=>'ChangeTS DESC')
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ArtikelAenderungslog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
