<?php

/**
 * Das Helper Modell stellt Funktionen zur Verfügung die von mehreren Modellen oder Controllern gleichzeitig benutzer werden sollen
 */
class Helper extends CActiveRecord
{

    /**
     * Löscht aus Post String alle gefährlichen HTML strings ausser p,b,i,br,h1,h2,h3
     * @param mixed $post
     */
    public static function cleanAllInputData($post)
    {
        $purifier = new CHtmlPurifier();
        $purifier->options = array(
            //'HTML.Allowed' => 'p,a[href],b,i',
            'HTML.Allowed' => 'p,b,i,br,h1,h2,h3',
        );
        foreach ($post as $key => $val) {
            $post[$key] = $purifier->purify($val);
        }
        return $post;
    }

    /**
     * Formatiert eine Zahl im Format "1234,00 €"
     * 
     * @param mixed $number
     */
    public static function formatToEuro($number)
    {
        return  number_format($number, 2, ",", "") . " €";
    }

    /**
     * Stellt Zugriff auf VorerfassungsDB her und liefert verbindung zurück wenn ok
     */
    public static function getVorerfassungsDB()
    {
        //details siehe http://www.yiiframework.com/doc/api/1.1/CSqlDataProvider
        try {
            $db = Yii::app()->db_vorerfassung; //muss in config/main.php entsprechend gepflegt sein
            //versuche auf die tabellen artikel und users zuzugreifen
            $db->createCommand("select name from articles limit 1")->queryScalar();
            $db->createCommand("select id from users limit 1")->queryScalar();
            return $db;
        } catch (Exception $e) {
            throw new CHttpException(500, 'Auf die Vorerfassungsdatenbank konnte nicht zugegriffen werden, möglicherweise wurde sie nicht in main.php falsch gepflegt oder soll nicht verwendet werden. Original Exception: ' . $e->getMessage());
            return null;
        }
    }
}
