<?php

/**
 * This is the model class for table "kunden".
 *
 * The followings are the available columns in table 'kunden':
 * @property string $KundenNr
 * @property string $Name
 * @property string $Telefon
 * @property string $Email
 * @property string $PLZ
 * @property string $Kommentar
 * @property string $AbgerechnetFlag
 * @property string $AbgerechnetTS
 * @property string $VerwaltungBezahltFlag
 * @property string $ImportID
 * @property string $Email
 */
class Kunden extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'kunden';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('Name, Telefon', 'required'),
            array('Name, Telefon', 'length', 'max' => 100),
            array('Kommentar, Email', 'length', 'max' => 300),
            array('AbgerechnetFlag, VerwaltungBezahltFlag', 'length', 'max' => 6),
            array('AbgerechnetTS', 'safe'),
            array('AbgerechnetFlag', 'in', 'range' => array('Ja', 'Nein'), 'allowEmpty' => false, 'message' => 'Es sind nur die Werte Ja oder Nein erlaubt'),
            array('KundenNr, ImportID', 'unique'), //kundennummer und importid müssen eindeutig sein
            // The following rule is used by search().
            // todo Please remove those attributes that should not be searched.
            array('KundenNr, Name, Telefon, Email, PLZ, Kommentar, AbgerechnetFlag, AbgerechnetTS, ImportID', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array();
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'KundenNr' => 'Kunden Nr',
            'Name' => 'Name',
            'Telefon' => 'Telefon',
            'Email' => 'eMail',
            'PLZ' => 'PLZ',
            'Kommentar' => 'Kommentar',
            'AbgerechnetFlag' => 'Abgerechnet',
            'AbgerechnetTS' => 'Abgerechnet am/um',
            'VerwaltungBezahltFlag' => 'Verwaltungsabgabe bezahlt',
            'ImportID' => 'Import ID',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('KundenNr', $this->KundenNr, false); //immer exakt
        $criteria->compare('Name', $this->Name, true);
        $criteria->compare('Telefon', $this->Telefon, true);
        $criteria->compare('Email', $this->Email, true);
        $criteria->compare('PLZ', $this->PLZ, true);
        $criteria->compare('Kommentar', $this->Kommentar, true);
        $criteria->compare('AbgerechnetFlag', $this->AbgerechnetFlag, true);
        $criteria->compare('AbgerechnetTS', $this->AbgerechnetTS, true);
        $criteria->compare('VerwaltungBezahltFlag', $this->VerwaltungBezahltFlag, true);
        $criteria->compare('ImportID', $this->ImportID, false);  //immer exakt

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => 50,), //50 kunden pro seite
            'sort' => array(
                'defaultOrder' => 'KundenNr DESC'
            )
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Kunden the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    /**
     * Liefert einen Dataprovider für die Kunden aus der VorerfassungsDB V2
     * 
     * @param mixed $pagesize - optional die anzahl der einträge pro seite
     * @return CSqlDataProvider
     */
    public function getKundenVorerfassung($pagesize = 1000)
    {
        //zugriff auf vorerfassungsDB
        $db = Helper::getVorerfassungsDB();
        $sql_count = "SELECT COUNT(*) FROM (SELECT user_id FROM articles group by user_id) AS amount_users_with_articles";
        $sql = "SELECT a.id,a.name,a.email,(select count(*) from articles c where a.id=c.user_id) as anzahl_artikel FROM users a,articles b where a.id=b.user_id group by a.id";
        $key_field = 'id';
        $count = $db->createCommand($sql_count)->queryScalar();
        $dataProvider = new CSqlDataProvider($sql, array(
            'totalItemCount' => $count,
            'keyField' => $key_field,
            'db' => $db,
            'pagination' => array(
                'pageSize' => $pagesize,
            ),
        ));
        return $dataProvider;
    }

    /**
     * Liefert nicht abgerechnete Kunden zurück
     * 
     * @param mixed $amount - anzahl wieviele Kunden maximal
     */
    public function getNichtAbgerechneteKunden($amount)
    {
        $sql = "SELECT KundenNr FROM kunden where AbgerechnetFlag='Nein' limit " . (int)$amount;

        $data = Yii::app()->db
            ->createCommand($sql)
            ->queryAll();
        return $data;
    }

    /**
     * Importiert den Kunden aus der VorerfassungsDB
     * @param mixed $id - ID unter der der Kunde in der VorerfassungsDB aufgeführt ist
     */
    public function importKundeVorerfassung($id)
    {
        //sicherstellen, dass id nur nummerisch ist
        $id = intval($id);

        //zugriff auf vorerfassungsDB
        $db = Helper::getVorerfassungsDB();
        $sql = "SELECT `id`,`name`,`phone`,`email` FROM users where `id`=" . $id . "";
        $vorerfassungs_data = $db->createCommand($sql)->queryAll();

        //komische strings ausfiltern und dadurch diverse angriffe unterbinden
        $vorerfassungs_data = Helper::cleanAllInputData($vorerfassungs_data);

        //prüfung ob alle wichtigen daten vorhanden
        if (isset($vorerfassungs_data[0]["id"]) && isset($vorerfassungs_data[0]["name"]) && isset($vorerfassungs_data[0]["phone"]) && $vorerfassungs_data[0]["email"]) {
            //daten validieren und speichern

            //Prüfen ob kunde schon importiert wurde und wenn ja ersetzen und infomeldung
            $model = Kunden::model()->findByAttributes(array('ImportID' => $id));

            if ($model == null) {
                //nur bei erstimport setzen
                $model = new Kunden;
                $model->ImportID = $vorerfassungs_data[0]["id"];
            } else {
                Yii::app()->user->setFlash('import_notice', 'Hinweis: KundeNr ' . $model->KundenNr . ' (ImportID:' . $id . ') war bereits im System vorhanden und wurde soeben erneut importiert bzw. überschrieben.');
            }
            //init default values
            if (empty($vorerfassungs_data[0]["phone"])) {
                $vorerfassungs_data[0]["phone"] = "nicht bekannt";
            }

            //immer setzen
            $model->Name = $vorerfassungs_data[0]["name"];
            $model->Telefon = $vorerfassungs_data[0]["phone"];
            $model->Email = $vorerfassungs_data[0]["email"];
            $model->Kommentar = "Durch Import aus Vorerfassung erstellt";

            if ($model->save()) {
                return $model->KundenNr;
            } else {
                return null;
            }
        } else {
            return null;
        }
    }
}
