<?php

/**
 * This is the model class for table "parameter".
 *
 * The followings are the available columns in table 'parameter':
 * @property string $Name
 * @property string $Wert
 * @property integer $Laenge
 * @property string $Typ
 * @property string $Beschreibung
 */
class Parameter extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'parameter';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('Name, Beschreibung', 'required'),
			array('Laenge', 'numerical', 'integerOnly'=>true),
			array('Name', 'length', 'max'=>50),
			array('Typ', 'length', 'max'=>20),
			array('Beschreibung', 'length', 'max'=>300),
            array('Wert', 'validateWert','message'=>'Werteingabe ungültig, bitte Länge und Format beachten'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('Name, Wert, Laenge, Typ, Beschreibung', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'Name' => 'Name = technische ID',
			'Wert' => 'Wert',
			'Laenge' => 'max. Laenge',
			'Typ' => 'Datentyp',
			'Beschreibung' => 'Beschreibung',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		//  Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('Name',$this->Name,true);
		$criteria->compare('Wert',$this->Wert,true);
		$criteria->compare('Laenge',$this->Laenge);
		$criteria->compare('Typ',$this->Typ,true);
		$criteria->compare('Beschreibung',$this->Beschreibung,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
            'pagination'=>array('pageSize'=>50),
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Parameter the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
    
    /**
    * Eigene Validierungsroutine um Wert des Parameters zu validieren
    * 
    * @param mixed $attribute
    * @param mixed $params
    */
    public function validateWert($attribute,$params)
    {
        //info von http://stackoverflow.com/questions/15516172/how-to-add-rules-using-yii-framework-in-model
        $error=null;
        $attribute_content=$this[$attribute];
        
        //ermittle typ und prüfe daten
        if($this->Typ=="text")
        {
            //keine prüfungen    
        }
        elseif($this->Typ=="zahl_1-99")
        {
            if(!is_numeric($attribute_content))
                $error=1;
            if((int)$attribute_content<0 || (int)$attribute_content>99)
                $error=1;    
        }
        elseif($this->Typ=="ganzzahl")
        {
            if(!is_numeric($attribute_content) || stristr($attribute_content,".") || stristr($attribute_content,","))
                $error=1; 
        }
        elseif($this->Typ=="float_0-10")
        {
            if(!is_numeric($attribute_content))
                $error=1;
            if((float)$attribute_content<0 || (float)$attribute_content>10)
                $error=1;            
        }
        elseif($this->Typ=="bool")
        {
            if($attribute_content!="1" && $attribute_content!="0")
                $error=1;    
        }
        elseif($this->Typ=="dd.mm.yyyy_hh:mm:ss")
        {
            if(strtotime($attribute_content)==false)
                $error=1;
            if(strlen($attribute_content)!=19) 
                $error=1;    
        }
        
        //prüfe länge
        if(strlen($attribute_content)>$this->Laenge)
        {
            $error=1;
        }
        
        if($error)
        {
            //$this->addError('duration','validation message');
            $this->addError($attribute,$params['message']);
        }
    }
    
    /**
    * Liefert alle in den Parametern definierten Drucktypen in einem array mit id/anzahl zurück
    */
    public function getDrucktypen()
    {
        $return=array();
        $typen=Parameter::model()->findByPk("etiketten_typen")->Wert;     
        $split_full=explode(";",$typen);
        foreach($split_full as $item)
        {
            $split_single=explode(",",$item);
            if(isset($split_single[0]) && isset($split_single[1]) && $split_single[0]!="" && intval($split_single[1])!=0)
            {
                $typ=preg_replace('/[^0-9A-Za-z]/', "_",$split_single[0]);
                $anzahl_etiketten_pro_seite=intval($split_single[1]);
                array_push($return,array("id"=>$typ,"anzahl"=>$anzahl_etiketten_pro_seite,"name"=>$typ." (".$anzahl_etiketten_pro_seite." Stück pro Blatt)"));
            }
            
        }
        return $return;
    }
}
