<?php

/**
 * This is the model class for table "reklamation".
 *
 * The followings are the available columns in table 'reklamation':
 * @property string $ReklamationNr
 * @property string $RefKundenNr
 * @property string $RefArtikelNr
 * @property string $Beschwerde
 * @property string $AngedachteLoesung
 * @property string $Status
 * @property string $ErfassungTS
 */
class Reklamation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'reklamation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            array('RefKundenNr, RefArtikelNr, Beschwerde', 'required'),
			//array('RefKundenNr, RefArtikelNr', 'numerical','message' =>'Bitte nur die im Systeme vorhandene KundenNr und ArtikelNr angeben, ggf. Kunde und Artikel vorher anlegen.'),
			array('RefKundenNr, RefArtikelNr', 'length', 'max'=>50),
			array('Beschwerde, AngedachteLoesung', 'length', 'max'=>3000),
			array('Status', 'length', 'max'=>50),
			array('ErfassungTS', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('ReklamationNr, RefKundenNr, RefArtikelNr, Beschwerde, AngedachteLoesung, Status, ErfassungTS', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'ReklamationNr' => 'ReklamationNr',
			'RefKundenNr' => 'KundenNr',
			'RefArtikelNr' => 'ArtikelNr',
			'Beschwerde' => 'Beschwerde',
			'AngedachteLoesung' => 'Angedachte Lösung',
			'Status' => 'Status',
			'ErfassungTS' => 'Erfassungszeitpunkt',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('ReklamationNr',$this->ReklamationNr,true);
		$criteria->compare('RefKundenNr',$this->RefKundenNr,true);
		$criteria->compare('RefArtikelNr',$this->RefArtikelNr,true);
		$criteria->compare('Beschwerde',$this->Beschwerde,true);
		$criteria->compare('AngedachteLoesung',$this->AngedachteLoesung,true);
		$criteria->compare('Status',$this->Status,true);
		$criteria->compare('ErfassungTS',$this->ErfassungTS,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
            'sort'=>array(
                'defaultOrder'=>'Status DESC')
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Reklamation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
