<?php

/**
 * This is the model class for Statistik, liefert die ganzen Dataprovider für die Statistik views
 * 
 */
//class Statistik extends CActiveRecord - nur mit db table
class Statistik extends CModel  //cmodel für modelle ohne dbzugriff verwenden
{  
    
    //wird zwingend benötigt bei einer CModel Klasse
    public function attributeNames()
    {
        //return array( 'ArtikelNr', 'Name', 'Marke' );
        return array(  );
    }
    
    /**
    * Liefert einen Generischen Dataprovider anhande des übergebenen SQLs zurück
    * 
    * @param mixed $sql - SQL welches ausgeführt werden soll (zb: SELECT * FROM Artikel)
    * @param mixed $sql_count - SQL für Anzahl der Werte (zb: SELECT count(*) FROM Artikel)
    * @param mixed $$key_field - Name des Schlüsselfelds in den SQL Daten (Überlicherweise das Primary Feld)
    * @param mixed $pagesize - Optional: Wieviele Einträge pro seite, default=1000
    * @return CSqlDataProvider
    */
    public function getGenericDataproviderBySQL($sql,$sql_count,$key_field,$pagesize=1000)
    {   
        //details siehe http://www.yiiframework.com/doc/api/1.1/CSqlDataProvider
        $count=Yii::app()->db->createCommand($sql_count)->queryScalar();
        $dataProvider=new CSqlDataProvider($sql, array(
            'totalItemCount'=>$count,
            'keyField'=>$key_field,
            'pagination'=>array(
                'pageSize'=>$pagesize,
            ),
        ));
        return $dataProvider;
    }
    
    /**
    * Liefert diverse Statistikdaten, aktueller Umsatz, aktuelle Provision, AnzahlArtikel, etc
    */
    public static function getDataUmsatz()
    {
        $sql="SELECT sum(preis-(preis*VerkauftRabattProz/100)) as Summe FROM artikel where VerkauftFlag='Ja'";
        return Helper::formatToEuro(Yii::app()->db->createCommand($sql)->queryScalar());
    } 
    /**
    * Liefert diverse Statistikdaten, aktueller Umsatz, aktuelle Provision, AnzahlArtikel, etc
    */
    public static function getDataProvision()
    {
        $calc_provision=(int)Parameter::model()->findByPk("abrechnung_provision_prozent")->Wert; 
        $sql="SELECT sum(preis-(preis*VerkauftRabattProz/100))/100*".$calc_provision." as Summe FROM artikel where VerkauftFlag='Ja'";
        return Helper::formatToEuro(Yii::app()->db->createCommand($sql)->queryScalar());
    }
    /**
    * Liefert diverse Statistikdaten, aktueller Umsatz, aktuelle Provision, AnzahlArtikel, etc
    */
    public static function getDataGesamtwert()
    { 
        $sql="SELECT sum(Preis) FROM artikel";
        return Helper::formatToEuro(Yii::app()->db->createCommand($sql)->queryScalar());
    } 
    
    /**
    * Liefert diverse Statistikdaten, aktueller Umsatz, aktuelle Provision, AnzahlArtikel, etc
    */
    public static function getDataAnnahmegebuehr()
    { 
        $annahme_gebuehr=(float)Parameter::model()->findByPk("abrechnung_betrag_verwaltungsaufwand")->Wert; 
        //$sql="SELECT count(*)*0.5 FROM artikel where refkundennr in (SELECT kundennr FROM kunden where verwaltungbezahltflag <> 'Intern')";
        $sql="SELECT count(*)*".$annahme_gebuehr." FROM artikel where refkundennr in (SELECT kundennr FROM kunden where verwaltungbezahltflag <> 'Intern')";
        return Helper::formatToEuro(Yii::app()->db->createCommand($sql)->queryScalar());
    } 
    
    /**
    * Liefert diverse Statistikdaten, aktueller Umsatz, aktuelle Provision, AnzahlArtikel, etc
    */
    public static function getDataKundenAllesVerkauft()
    { 
        $return ="";
        $sql="SELECT a.KundenNr FROM kunden a where (SELECT count(*) FROM artikel b where a.kundennr=b.RefKundenNr and verkauftTS is null)=0 and (SELECT count(*) FROM artikel b where a.kundennr=b.RefKundenNr)>0";
        //$sql="SELECT kundennr FROM kunden where kundennr<5";
        $array= Yii::app()->db->createCommand($sql)->queryAll();
        foreach($array as $key=>$val)
        {
            //return $key."-".$val;
            if(isset($val["KundenNr"]))
                $return.=$val["KundenNr"].", ";
        }
        $return=substr($return,0,-2);
        return $return;
    } 
    

    
    /**
    * Liefert diverse Statistikdaten, aktueller Umsatz, aktuelle Provision, AnzahlArtikel, etc
    */
    public static function getDataArtikelanzahl()
    { 
        $sql="SELECT count(*) FROM artikel";
        return Yii::app()->db->createCommand($sql)->queryScalar();
    }
    /**
    * Liefert diverse Statistikdaten, aktueller Umsatz, aktuelle Provision, AnzahlArtikel, etc
    */
    public static function getDataKundenanzahl()
    { 
        $sql="SELECT count(*) FROM kunden";
        return Yii::app()->db->createCommand($sql)->queryScalar();
    }
    /**
    * Liefert die Anzahl der Artikel die vergünstigt verkauft wurden
    */
    public static function getDataHappyHourArtikelanzahl()
    { 
        $sql="SELECT count(*) FROM artikel where VerkauftRabattProz>0";
        return Yii::app()->db->createCommand($sql)->queryScalar();
    }
    /**
    * Liefert gesamtumsatz der vergünstigt verkauften artikel
    */
    public static function getDataHappyHourUmsatz()
    {
        $sql="SELECT sum(preis-(preis*VerkauftRabattProz/100)) as Summe FROM artikel where VerkauftFlag='Ja' and VerkauftRabattProz>0";
        return Helper::formatToEuro(Yii::app()->db->createCommand($sql)->queryScalar());
    }  
    
    /**
    * Liefert die Anzahl der Artikel die verkauft wurden
    */
    public static function getDataVerkauftArtikelanzahl()
    { 
        $sql="SELECT count(*) FROM artikel where VerkauftFlag='Ja'";
        return Yii::app()->db->createCommand($sql)->queryScalar();
    }
    
    
    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Kunden the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }          
  
}


?>
