<?php

/**
 * This is the model class for table "verkauf".
 *
 * The followings are the available columns in table 'verkauf':
 * @property string $ID
 * @property string $SessionID
 * @property string $ErfassterBarcode
 * @property string $RefArtikelNr
 * @property string $ErfassungTS
 * @property string $VerkaufErledigt
 */
class Verkauf extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'verkauf';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('ErfassterBarcode', 'required'),
			array('SessionID', 'length', 'max'=>100),
			array('ErfassterBarcode', 'length', 'max'=>50),
			array('RefArtikelNr', 'length', 'max'=>20),
			array('VerkaufErledigt', 'length', 'max'=>5),
			// The following rule is used by search().
			// todo Please remove those attributes that should not be searched.
			array('ID, SessionID, ErfassterBarcode, RefArtikelNr, ErfassungTS, VerkaufErledigt', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'ID' => 'ID',
			'SessionID' => 'Session',
			'ErfassterBarcode' => 'Barcode',
			'RefArtikelNr' => 'ArtikelNr',
			'ErfassungTS' => 'Erfassungzeit',
			'VerkaufErledigt' => 'Verkauf Erledigt',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('ID',$this->ID,true);
		$criteria->compare('SessionID',$this->SessionID,true);
		$criteria->compare('ErfassterBarcode',$this->ErfassterBarcode,true);
		$criteria->compare('RefArtikelNr',$this->RefArtikelNr,true);
		$criteria->compare('ErfassungTS',$this->ErfassungTS,true);
		$criteria->compare('VerkaufErledigt',$this->VerkaufErledigt,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
            'pagination'=>array('pageSize'=>50,), //50 einträge pro seite
            'sort'=>array(
                'defaultOrder'=>'ErfassungTS DESC')
		));
	}
    
    /**
     * Liefert 99999 Verkäufe auf einer Seite sortiert nach ID, wo ErfassungTS=ja und RefArtikelNr <> ""
     */
    public function searchAllValid($id_gt=0)
    {
        // todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('ID',$this->ID,true);
        //$criteria->compare('RefArtikelNr',$this->RefArtikelNr,true);
        $criteria->addCondition('RefArtikelNr <> ""');   
        $criteria->addCondition('ID > '.$id_gt.'');   
        $criteria->compare('VerkaufErledigt',"Ja",true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
            'pagination'=>array('pageSize'=>99999,), //99999 einträge pro seite
            'sort'=>array(
                'defaultOrder'=>'ID ASC')
        ));
    }
    
    /**
    * Liefert die aktuelle SessionID zurück
    */
    public function getCurrentSessionID()
    {   
        //return "H:".$_SERVER["REMOTE_ADDR"]."_B:".md5($_SERVER["HTTP_USER_AGENT"]);
        return "H:".$this->getCurrentClientIP()."_B:".md5($_SERVER["HTTP_USER_AGENT"]);
    }
    
    /**
    * Ermittelt die aktuelle Client IP
    */
    public function getCurrentClientIP()
    {
         $ipaddress = '';
         if (getenv('HTTP_CLIENT_IP'))
             $ipaddress = getenv('HTTP_CLIENT_IP');
         else if(getenv('HTTP_X_FORWARDED_FOR'))
             $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
         else if(getenv('HTTP_X_FORWARDED'))
             $ipaddress = getenv('HTTP_X_FORWARDED');
         else if(getenv('HTTP_FORWARDED_FOR'))
             $ipaddress = getenv('HTTP_FORWARDED_FOR');
         else if(getenv('HTTP_FORWARDED'))
             $ipaddress = getenv('HTTP_FORWARDED');
         else if(getenv('REMOTE_ADDR') && getenv('REMOTE_ADDR')=="::1")
             $ipaddress = "127.0.0.1";
         else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
         else
             $ipaddress = 'UNKNOWN';

         return $ipaddress; 
    }
        
    
    
    /**
    * Convertiert einen Barcode in eine Artikelnummer
    * @param mixed $barcode
    */
    public static function convertBarcodeToArtikelnr($barcode)
    {
        //versuche artikelnummer herauszulesen
        $temp_artikelnr=null;
        if(strlen($barcode)==13 && is_numeric($barcode))
        {
            $temp_artikelnr=(int)substr($barcode,4,8); //die ersten 4 stellen wegschneiden und die prüfziffer -> artikelnummer    
        }
        elseif(is_numeric($barcode) && strlen($barcode)<=13)
        {
            $temp_artikelnr=(int)$barcode;        
        }
        else
        {
            $temp_artikelnr= null;
        }
        return $temp_artikelnr;   
    }
    
    
    
    /**
    * Sucht zu einer Artikelnummer oder Barcode den passenden Artikel
    * @param mixed $barcode
    */
    public function searchArtikelNrfromBarcode($barcode)
    {
        $temp_artikelnr=self::convertBarcodeToArtikelnr($barcode);
        
        //versuche zur temp artikel nr einen Artikel im System zu finden
        $model=Artikel::model()->findByPk($temp_artikelnr);
        if($model!=null && isset($model->ArtikelNr))
        {
            return $model->ArtikelNr;
        }
        else
        {
            return null;
        }
    }
    
    /**
    * Berechnet die Summe der aktuellen Verkaufsliste unter berücksichtigung alle HappyHour Einstellungen durch Aufruf von Funktion calcVerkaufsPreis
    */
    public function calcSumme()
    {
        $sessionid=Verkauf::model()->getCurrentSessionID();
        /*
        $sql_sum=null;
        $sql_sum = Yii::app()->db->createCommand("SELECT sum(b.preis) as summe FROM verkauf a,artikel b where a.sessionid='".$sessionid."' and a.VerkaufErledigt='Nein' and a.RefArtikelNr is not null and a.RefArtikelNr=b.ArtikelNr")->queryScalar();
        
        if(isset($sql_sum) && $sql_sum!="")
            return number_format ( $sql_sum , 2 , "," , "" )." €";
        else
            return "0,00 €"; */
            
        $sql_list=null;
        $sql_list = Yii::app()->db->createCommand("SELECT a.ErfassungTS,b.ArtikelNr FROM verkauf a,artikel b where a.sessionid='".$sessionid."' and a.VerkaufErledigt='Nein' and a.RefArtikelNr is not null and a.RefArtikelNr=b.ArtikelNr")->queryAll();
        $sum=0;
        foreach($sql_list as $item)
        {
            $sum=$sum+self::calcVerkaufsPreis($item["ErfassungTS"],$item["ArtikelNr"],true);
        }
        
        return number_format ( $sum , 2 , "," , "" )." €";
        
    }
    
    /**
    * Ermittelt den gültigen Preis für Zeitpunkt/Artikel unter berücksichtigung alle HappyHour Einstellungen, siehe auch CalcSumme
    * 
    * @param mixed $ErfassungsTS
    * @param mixed $ArtikelNr
    * @param mixed $raw - Ausgabeformat: default ist lesbar, zB 23,30€, raw=true bewirkt float rückgabe
    * @return mixed 
    */
    public static function calcVerkaufsPreis($ErfassungTS,$ArtikelNr,$raw=false)
    {     
        //lese artikel zu verkauf
        $model = Artikel::model()->findByPk($ArtikelNr);
        //lese parameter
        $happyhour_start=strtotime(Parameter::model()->findByPk("happyhour_starttime")->Wert); 
        $happyhour_prozent=(int)Parameter::model()->findByPk("happyhour_prozent")->Wert; 
        
        //prüfe ob alle werte vorhanden sind
        if($happyhour_start!=false && isset($ErfassungTS) && $ErfassungTS!="" && strtotime($ErfassungTS)!=false  && isset($model->Preis) && isset($model->HappyHourFlag))
        {
            
            if($model->HappyHourFlag=="Ja")
            {
                $ts_erfassung=strtotime($ErfassungTS);
                if($ts_erfassung>=$happyhour_start)
                {
                    //happy hour preis
                    $preis=(float)$model->Preis-((float)$model->Preis*$happyhour_prozent/100);    
                }
                else
                {
                    //normal preis, da zwar happy hour möglich aber zeit noch nicht erreicht
                    $preis=(float)$model->Preis;   
                }
                
                if($raw==false)
                    return number_format ( $preis , 2 , "," , "" )." €"; 
                else
                    return $preis;   
            }
            else
            {
                //artikel erlaubt keine happy hour
                if($raw==false)
                    return number_format ( $model->Preis , 2 , "," , "" )." €"; 
                else
                    return $model->Preis;   
            }
             
        }
        else
        {
            return "error";
        }
        
        
    }
    
    /**
    * Liefert den zuletzt gescannten Artikel daten als Array der aktuellen Session inklusive des Mit HappyHour berücksichtigten preises
    */
    public function getLastScannedArtikelData()
    {
        $return=null;
        $sessionid=Verkauf::model()->getCurrentSessionID();
        $sql="SELECT RefArtikelNr,ErfassungTS FROM verkauf a where a.sessionid='".$sessionid."' and a.VerkaufErledigt='Nein' order by a.id desc limit 1";
        $list = Yii::app()->db->createCommand($sql)->queryAll();
        
        if(isset($list[0]["RefArtikelNr"]) && $list[0]["RefArtikelNr"]!="")
            $model=Artikel::model()->findByPk($list[0]["RefArtikelNr"]);
        
        if(isset($model) && is_object($model) && isset($list[0]["ErfassungTS"]) && $list[0]["ErfassungTS"]!="")
        {
            //berechne aktuellen preis
            $verkaufspreis=self::calcVerkaufsPreis($list[0]["ErfassungTS"],$list[0]["RefArtikelNr"],true);
            $return["Originalpreis"]=number_format ( (float)$model->Preis , 2 , "," , "" )." €";
            $return["Verkaufspreis"]=number_format ( (float)$verkaufspreis , 2 , "," , "" )." €";
            $return["ArtikelNr"]=$model->ArtikelNr;
            $return["Image"]=$model->Image;
            $return["Name"]=$model->Name;  
            $return["Info"]="";
            if((float)$verkaufspreis<(float)$model->Preis)
            {
                $return["Info"]=" statt ".$return["Originalpreis"];    
            }
        }

        return $return;

    }
    

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Verkauf the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
