<?php

/**
 * This is the model class for table "warengruppe".
 *
 * The followings are the available columns in table 'warengruppe':
 * @property string $ID
 * @property string $Name
 */
class Warengruppe extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'warengruppe';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('Name', 'required'),
			array('Name', 'length', 'max'=>100),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('ID, Name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'ID' => 'ID',
			'Name' => 'Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('ID',$this->ID,true);
		$criteria->compare('Name',$this->Name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
            'pagination'=>array('pageSize'=>100), //100 artikel pro seite
            'sort'=>array(
                'defaultOrder'=>'Name ASC')
		));
	}
    
    /**
    * Suche für Creat Liste
    * 
    */
    public function searchForCreate()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('ID',$this->ID,true);
        $criteria->compare('Name',$this->Name,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
            'pagination'=>array('pageSize'=>10), //10 artikel pro seite
            'sort'=>array(
                'defaultOrder'=>'ID DESC')
        ));
    }

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Warengruppe the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
    
    /**
    * Prüft ob der Name einer Warengruppe exisitiert, legt diese ggf. an und gibt die ID der Warengruppe zurück
    * 
    * @param mixed $name - Name der warengruppe
    * @return mixed $id - ID der warengruppe
    */
    public function checkWarengruppe($name)
    {
        $model = Warengruppe::model()->findByAttributes(array('Name'=>$name));
        if($model!=null && isset($model->ID) && $model->ID!="")
        {
            return $model->ID;
        }
        elseif($name!="" && strlen($name)<=100)
        {
            $model=new Warengruppe;
            $post_data["Name"]=$name;
            $post_data=Helper::cleanAllInputData($post_data);
            $model->attributes=$post_data;
            
            if($model->save())
                return $model->ID;
            else
                return null;
        }
        else
        {
            return null;
        }
    }
    
    /**
    * Exportiert alle im Tauschmarkt definierten Warengruppen an die Vorerfassung
    */
    public function exportWagengruppenVorerfassung()
    {
        $error_string="";
        $export_ids_string="";
        $error_array=array();
        $error_array_sqlstring="";
        
        //zugriff auf vorerfassungsDB
        $db=Helper::getVorerfassungsDB();
        
        //ermittle bereits in vorerfassung verwendete warengruppen
        $sql="SELECT * FROM warengruppe where id in (select RefWarengruppeID from artikel group by RefWarengruppeID)";
        $vorerfassung_verwendete_warengruppen=$db->createCommand($sql)->queryAll();
        
        //prüfe ob alle verwendeten warengruppen gleich geblieben sind
        foreach($vorerfassung_verwendete_warengruppen as $wgr)
        {
            if(isset($wgr["ID"]))
                $wgr_model=Warengruppe::model()->findByPk($wgr["ID"]);
            if(isset($wgr_model->Name) && isset($wgr["Name"]))
            {
                //prüfung ob änderung vorhanden
                if(strtolower($wgr_model->Name)!=strtolower($wgr["Name"]))
                {
                    $error_string.="Error - WGR-ID:".$wgr["ID"]." konnte nicht exportiert werden da sie in der Vorerfassung bereits verwendet wird und die Bezeichnungen von '".$wgr["Name"]."' auf '".$wgr_model->Name."' geändert wurde. ";
                    $error_array[$wgr["ID"]]="";
                    $error_array_sqlstring.=$wgr["ID"].",";
                }
            }
        }
        
        
        //lösche alle datensätze bis auf die oben ausgefilterten
        if($error_array_sqlstring!="")
            $sql="delete from warengruppe where id not in (".substr($error_array_sqlstring,0,-1).")";
        else
            $sql="delete from warengruppe";
        $db->createCommand($sql)->query();
        
        //exportiere alle WGR bis auf die oben ausgefilterten
        $model=Warengruppe::model();
        $model->unsetAttributes();
        $model_all_wgr=$model->search()->getData();
        foreach($model_all_wgr as $wgr)
        {
            if(isset($wgr->ID) && isset($wgr->Name) && !isset($error_array[$wgr->ID]))
            {
                //insert datensatz
                $sql="insert into warengruppe (id,name) values (".$wgr->ID.",'".$wgr->Name."');";
                $return=$db->createCommand($sql)->query();
                
                $export_ids_string.=$wgr->ID.", ";   
            }
            
        }
        
        //rückmeldung zur darstellung als flash message
        if(count($error_array)>0)
            return $error_string." Folgende WGR-IDs wurden erfolgreich exportiert: ".$export_ids_string;
        else
            return "Folgende WGR-IDs wurden erfolgreich exportiert: ".$export_ids_string; 
        
    }
            
}
