<?php
/* @var $this ArtikelController */
/* @var $model Artikel */
/* @var $form CActiveForm */
?>

<div class="form">

<?php 

//ändere curser fokus wenn automatische artikelnummer eingegeben wurde
$curser_focus="ArtikelNr";
if(isset($genartnr) && $genartnr!="")
    $curser_focus="Name";    

$form=$this->beginWidget('CActiveForm', array(
	'id'=>'artikel-form',
	// Please note: When you enable ajax validation, make sure the corresponding
	// controller action is handling ajax validation correctly.
	// There is a call to performAjaxValidation() commented in generated controller code.
	// See class documentation of CActiveForm for details on this.
	'enableAjaxValidation'=>true,
    //needed for upload
    'htmlOptions' => array(
        'enctype' => 'multipart/form-data',
    ),
    'focus'=>array($model,$curser_focus), //fokus auf element artikelnr, bzw name
)); ?>


<?php

//vorbereitung aller select daten    

//info von http://www.yiiframework.com/wiki/48/by-example-chtml/ 
//und http://stackoverflow.com/questions/11324750/select-or-dropdown-list-from-cactiverecord-in-yii  

// retrieve the models from db
$kunden_data = Kunden::model()->findAll(array('order' => 'Name'));

// format models as $key=>$value with listData
$kunden_list = CHtml::listData($kunden_data, 'KundenNr', 'Name');

//schreibe ID hinten an kundenliste dran
foreach($kunden_list as $temp_key=>$temp_val)
{
    $kunden_list[$temp_key]=$temp_key." - ".$temp_val;    
}

//Now, we generate our dropdowList from the $list variable
//echo CHtml::dropDownList('RefKundenID', '', $kunden_list,array('empty' => '(Einen Kunden auswählen)'));



// alle warengruppen aus model auslesen
$wgr_data = Warengruppe::model()->findAll(array('order' => 'Name'));
// format models as $key=>$value with listData
$wgr_list = CHtml::listData($wgr_data, 'ID', 'Name');
//schreibe ID hinten an wgrliste dran
foreach($wgr_list as $temp_key=>$temp_val)
{ 
    $wgr_list[$temp_key]=$temp_val." (".$temp_key.")";    
}  


//für happy hour flag
$option_list['Nein']='Nein';
$option_list['Ja']='Ja';   

//berechnung ob preisänderung erlaubt oder nicht
$change_preis_allowed=1;
if(isset(Parameter::model()->findByPK("preisaenderung_verboten_ab")->Wert) && Parameter::model()->findByPK("preisaenderung_verboten_ab")->Wert!="")
{
    $preisaenderung_verboten_ab=strtotime(Parameter::model()->findByPk("preisaenderung_verboten_ab")->Wert);
    $current_time=time();
    if($preisaenderung_verboten_ab<$current_time)
        $change_preis_allowed=0;         
}
//wenn als admin unterwegs dann immer preisändern erlaubt
if(!Yii::app()->user->isGuest && Yii::app()->user->name=="admin")
    $change_preis_allowed=1;  
    
//parameter show_artikelnr_by_system_button einlesen
$show_artnr_by_system_btn=1;
if(isset(Parameter::model()->findByPK("show_artikelnr_by_system_button")->Wert) && Parameter::model()->findByPK("show_artikelnr_by_system_button")->Wert!="")
{
    $temp=Parameter::model()->findByPk("show_artikelnr_by_system_button")->Wert;
    if((int)$temp==0)
        $show_artnr_by_system_btn=0;
    else
        $show_artnr_by_system_btn=1;       
}  

?>    


	<p class="note">Fields with <span class="required">*</span> are required.</p>

	<?php echo $form->errorSummary($model); ?>

    <?php if($model->isNewRecord): ?>
        <div class="row">
            <?php echo $form->labelEx($model,'ArtikelNr'); ?>
            <?php 
                if(isset($genartnr) && $genartnr!="")
                    echo $form->textField($model,'ArtikelNr',array('size'=>20,'maxlength'=>20, 'value'=>$genartnr, 'readonly'=>true, 'style'=>'color:grey;')); 
                else
                    echo $form->textField($model,'ArtikelNr',array('size'=>20,'maxlength'=>20)); 
            ?>
            <?php echo $form->error($model,'ArtikelNr'); ?>
            <?php 
                $kundennr=null;
                if(isset($model_kunden->KundenNr))
                    $kundennr=$model_kunden->KundenNr;
                if($show_artnr_by_system_btn==1)
                    echo CHtml::button('Artikelnummer durch System vergeben', array('submit' => array('artikel/genartnr','kundennr'=>$kundennr))); ?>
        </div>
    <?php endif; ?>
    
    <div class="row">
        <?php echo $form->labelEx($model,'Name'); ?>
        <?php echo $form->textField($model,'Name',array('size'=>60,'maxlength'=>100)); ?>
        <?php echo $form->error($model,'Name'); ?>
    </div>
    
    <div class="row">
        <?php echo $form->labelEx($model,'Groesse'); ?>
        <?php echo $form->textField($model,'Groesse',array('size'=>60,'maxlength'=>10)); ?>
        <?php echo $form->error($model,'Groesse'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model,'Marke'); ?>
        <?php echo $form->textField($model,'Marke',array('size'=>60,'maxlength'=>50)); ?>
        <?php echo $form->error($model,'Marke'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model,'RefWarengruppeID'); ?>
        <?php echo $form->dropDownList($model,'RefWarengruppeID', $wgr_list,array('empty' => '(Eine Warengruppe auswählen)')); ?>
        <?php echo $form->error($model,'RefWarengruppeID'); ?>
        <span class="hint">
            &nbsp;&nbsp;&nbsp; Neue Warengruppen können unter Setup-> Warengruppe angelegt werden.
        </span>
    </div>

    <?php if($change_preis_allowed || $model->isNewRecord): ?>
        <div class="row">
            <?php echo $form->labelEx($model,'Preis'); ?>
            <?php echo $form->textField($model,'Preis'); ?>
            <?php echo $form->error($model,'Preis'); ?>
        </div>
    <?php else: ?>
        <div class="row">
            <?php echo $form->labelEx($model,'Preis'); ?>
            <?php //echo $form->textField($model,'Preis'); ?>
            <?php echo $form->textField($model,'Preis',array('disabled'=>'true')); ?>
            <?php echo $form->error($model,'Preis'); ?>
            <span class="hint">
                &nbsp;&nbsp;&nbsp; Seit Start des Verkaufs um <?php echo Parameter::model()->findByPK("preisaenderung_verboten_ab")->Wert; ?> dürfen Preise nur noch vom Admin geändert werden.
            </span>
        </div>
    <?php endif; ?>
    
    <div class="row">
        <?php echo $form->labelEx($model,'Kommentar'); ?>
        <?php echo $form->textField($model,'Kommentar',array('size'=>60,'maxlength'=>300)); ?>
        <?php echo $form->error($model,'Kommentar'); ?>
    </div>
    
    
    <?php if(!$model->isNewRecord): ?>
        <div class="row">
            <?php echo $form->labelEx($model,'Image'); ?>
            <?php echo CHtml::activeFileField($model, 'Image'); ?>
            <?php echo $form->error($model,'Image'); ?>
        </div>
        <div class="row">
            <?php //echo CHtml::image(Yii::app()->request->baseUrl.'/images/upload/'.$model->Image,"",array("width"=>200)); ?>
            <?php
                //alte variante vollbild skaliert darstellen -> große datenmenge
                //$imghtml=CHtml::image(Yii::app()->request->baseUrl.'/images/upload/'.$data->Image,"",array("width"=>400));
                
                //thumbnail automatisch generieren und cachen -> kleine datenmenge, siehe auch http://www.yiiframework.com/extension/easyimage
                if($model->Image!=null && file_exists(Yii::getPathOfAlias('webroot').'/images/upload/'.$model->Image))
                {
                    $imghtml=Yii::app()->easyImage->thumbOf(Yii::getPathOfAlias('webroot').'/images/upload/'.$model->Image, 
                      array(
                        'resize' => array('width' => 350),
                      ));
                    
                    //$imghtml=CHtml::image('server/gallery/'.$data->gallery.'/th_'.$data->picturenumber.'.jpg', $data->picturenumber.'.jpg');
                    //$imghtml=CHtml::image(Yii::app()->request->baseUrl.'/images/upload/'.$model->Image,"",array("width"=>200));
                    //echo CHtml::link($imghtml, array('view', 'id'=>$data->id));
                    echo CHtml::link($imghtml, Yii::app()->request->baseUrl.'/images/upload/'.$model->Image, array("target"=>"_blank"));
                    
                    
                    
                }
            ?>
        </div>    
    <?php endif; ?>
    
    <?php if(!$model->isNewRecord): ?>
        <div class="row buttons">
            <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
        </div>
        <hr/>
        <h3>Folgende Attribute bitte nur in Absprache ändern wenn umbedingt notwendig:</h3>
        <div class="row">
            <?php echo $form->labelEx($model,'ArtikelNr'); ?>
            <?php echo $form->textField($model,'ArtikelNr',array('size'=>20,'maxlength'=>20)); ?>
            <?php echo $form->error($model,'ArtikelNr'); ?>
            <p class="hint">
                Vorsicht: Die Artikelnummer darf nur dann geändert werden, wenn es sich um einen Fehler handelt und die Artikelnummer mit der Artikelnummer auf dem Etikett nicht übereinstimmt. Der Kunde muss über diese Änderung informiert werden.
            </p>
        </div>
    <?php endif; ?>
    
    <!-- Kundenauswahl nur wenn fuer megtrere Kunden erfassbar-->
    <?php if(isset($model_kunden) && $model_kunden!=null):?>
        <?php echo $form->hiddenField($model,'RefKundenNr',array('value'=>$model_kunden->KundenNr)); ?>
    <?php else: ?>
        <div class="row">
            <?php echo $form->labelEx($model,'RefKundenNr'); ?>
            <?php echo $form->dropDownList($model,'RefKundenNr', $kunden_list,array('empty' => '(Einen Kunden auswählen)')); ?>
            <?php echo $form->error($model,'RefKundenNr'); ?>
        <?php if(!$model->isNewRecord): ?>
            <p class="hint">
                Vorsicht: Die Kundenzuordnung darf nur dann geändert werden, wenn es sich um einen Fehler handelt und die Artikelnummer bei der Erstellung irrtümlich dem falschen Kunden zugeordnet wurde. Der Kunde muss über diese Änderung informiert werden.
            </p>
        <?php endif; ?>
        </div>
    <?php endif; ?>
    
    <div class="row">
        <?php echo $form->labelEx($model,'HappyHourFlag'); ?>
        <?php echo $form->dropDownList($model,'HappyHourFlag', $option_list); ?>
        <?php echo $form->error($model,'HappyHourFlag'); ?>
        <p class="hint">
            Vorsicht: Der Parameter HappyHour soll nur in Abstimmung mit dem Kunden gesetzt werden, da der Artikel dadurch ab einem bestimmten Zeitpunkt günstiger verkauft wird.
        </p>
    </div>
   
    
    
    <?php if($model->isNewRecord): ?>
	    <div class="row buttons">
		    <?php echo CHtml::submitButton($model->isNewRecord ? 'Create (Enter)' : 'Save (Enter)'); ?>
	    </div>
    <?php endif; ?>

<?php $this->endWidget(); ?>

</div><!-- form -->