<?php
/* @var $this ArtikelController */
/* @var $model Artikel */

$this->breadcrumbs=array(
	'Artikel'=>array('index'),
	'Manage',
);

$this->menu=array(
	//array('label'=>'List Artikel', 'url'=>array('index')),
	array('label'=>'Erstelle Artikel (F10)', 'url'=>array('create')),
    array('label'=>'Drucke Etiketten', 'url'=>array('etikettendruck')),
    //array('label'=>'Liste nicht verkaufter Artikel', 'url'=>array('print')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#artikel-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Liste aller Artikel inkls. Suche</h1>

<!--<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>-->

<?php //echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'artikel-grid',
	'dataProvider'=>$model->search(),
    'template' => "{pager}{summary}\n{items}\n{pager}",
	'filter'=>$model,
	'columns'=>array(
	    'ErfassungTS',
        'ArtikelNr',
        'Name',
        'Preis',
        //'RefKundenNr',
        array(            
            'name'=>'RefKundenNr',
            'header'=>'Kunde',
            'value'=> array($this,'getKundenName') //function getArtikelName aus artikelController
        ),
        array(            
            'name'=>'RefWarengruppeID',
            'header'=>'Warengruppe',
            'value'=> array($this,'getWarengruppenName') //function getWarengruppenName aus artikelController
        ),
        'Groesse',
        'Marke',
        'VerkauftFlag',
        'VerkauftRabattProz',
        'HappyHourFlag',
        'VerkauftTS',
        //'Image',
        array(            
            'name'=>'Image',
            'header'=>'Image',
            'value'=> array($this,'getImageJaNein') //function getWarengruppenName aus artikelController
        ),
		array(
			'header'=> '&Auml;ndern',
            'class'=>'CButtonColumn',
            'template' => '{update}',
		),
        array //link auf reklamationsaufruf
            (
                'header'=>'Reklamation erfassen', 
                'class'=>'CButtonColumn',
                'template'=>'{reklamation}',
                'buttons'=>array
                (
                    'reklamation' => array
                    (
                        'label'=>'Reklamation erfassen',
                        'imageUrl'=>Yii::app()->request->baseUrl.'/images/icons/reklamation.png',
                        'url'=>'Yii::app()->createUrl("reklamation/create", array("RefArtikelNr"=>$data->ArtikelNr,"RefKundenNr"=>$data->RefKundenNr))',
                    ),
                ),
            ),
	),
)); ?>


