<?php
/* @var $this ArtikelController */
/* @var $model Artikel */

//variable um speziellen kundenviw zu verwenden
$kunden_view=0;
$model_kunden=null;

//wenn eine Kundennummer übergeben wurde lade das Kundenobjekt dazu
if(isset($_GET["KundenNr"]) && $_GET["KundenNr"]!="")
{
    //entferne alles ausser zahlken aus der nummer und versuche kundenmodell zu loaden
    $_GET["KundenNr"] = preg_replace('![^0-9]!', '', $_GET["KundenNr"]); 
    $model_kunden=Kunden::model()->findByPk($_GET["KundenNr"]);
    if(isset($model_kunden) && isset($model_kunden->KundenNr))
    {
        $kunden_view=1;    
    }    
    
}   


$this->breadcrumbs=array(
	'Artikel'=>array('index'),
	'Create',
);

if($kunden_view)
{
    $this->menu=array(
	    //array('label'=>'List Artikel', 'url'=>array('index')),
	    array('label'=>'Liste aller Artikel (F9)', 'url'=>array('admin')),
        array('label'=>'Liste aller Kunden (F1)', 'url'=>array('kunden/admin')),
        array('label'=>'Erstelle Kunden (F2)', 'url'=>array('kunden/create')),
        array('label'=>'Drucke Etiketten', 'url'=>array('etikettendruck','id'=>$model_kunden->KundenNr,'call'=>'search')),
        array('label'=>'Drucke Annahmeliste', 'url'=>array('kunden/print','id'=>$model_kunden->KundenNr)),
        array('label'=>'Drucke Abrechnung  (Vorsicht: nur einmalig möglich!)', 'url'=>array('kunden/printsum','id'=>$model_kunden->KundenNr)),
        array('label'=>'Voransicht Abrechnung', 'url'=>array('kunden/showsum','id'=>$model_kunden->KundenNr)),
    );
}
else
{
    $this->menu=array(
        //array('label'=>'List Artikel', 'url'=>array('index')),
        array('label'=>'Liste aller Artikel (F9)', 'url'=>array('admin')),
    );
}
?>

<?php
//fokussierung immer auf die artikel bezeichnung -> direkt in form gemacht
//Yii::app()->clientScript->registerScript('focus_artikenr', "$('#Artikel_ArtikelNr').focus();");
?>


<?php
    if($kunden_view)
    {
        echo "<h1>Erstelle Artikel für Kunde: ".$model_kunden->Name." (".$model_kunden->KundenNr.") </h1>";    
        
        $this->widget('zii.widgets.CDetailView', array(
            'data'=>$model_kunden,
            'attributes'=>array(
                'KundenNr',
                'Name',
                'Telefon',
                'Kommentar',
                'VerwaltungBezahltFlag',
            ),
        )); 
        echo "<br>";
        
    }
    else
    {
        echo "<h1>Erstelle Artikel für beliebige Kunden</h1>";    
    }
    
    
    
    
?>


<?php 
    $this->renderPartial('_form', array('model'=>$model,'model_kunden'=>$model_kunden, 'genartnr' =>$genartnr));
?>


<?php 
    
     //lösche verkaufsflag und happy hour flag und alle weiteren, damit für suche damit ja und nein angezeigt wird
    $model->unsetAttributes();  // clear any default values
    //$model->VerkauftFlag="";
    //$model->HappyHourFlag="";
    
    //limitiation der anzeige auf artikel nur für diesen kunden mit der Suche
    if($kunden_view)
    {
        //suche daten nur für diesen einen Kunden
        $model->RefKundenNr=$model_kunden->KundenNr;
        
        echo "<h1>Liste aller erstellten Artikel für Kunde: ".$model_kunden->Name." (".$model_kunden->KundenNr.")</h1>";        
    }
    else
    {
        echo "<h1>Liste aller erstellten Artikel für beliebige Kunden</h1>"; 
    }

    $this->widget('zii.widgets.grid.CGridView', array(
        'id'=>'artikel-grid',
        'dataProvider'=>$model->search(),
        'columns'=>array(
            'ErfassungTS',
            'ArtikelNr',
            'Name',
            'Preis',
            array(            
                'name'=>'RefWarengruppeID',
                'header'=>'Warengruppe',
                'value'=> array($this,'getWarengruppenName') //function getWarengruppenName aus artikelController
            ),
            'Groesse',
            'Marke',
            array(            
                'header'=>'Kunde',
                'value'=> array($this,'getKundenName') //function getKundenName aus artikelController
            ),
            'VerkauftFlag',
            'VerkauftRabattProz',
            'HappyHourFlag',
        ),
    )); 
?>



