<?php
/* @var $this KundenController */
/* @var $model Kunden */

$this->breadcrumbs=array(
	'Kunden'=>array('index'),
	'Manage',
);

$this->menu=array(
	//array('label'=>'List Kunden', 'url'=>array('index')),
    array('label'=>'Erstelle Kunden (F2)', 'url'=>array('create')),
    array('label'=>'Kunden aus Vorerfassung importieren', 'url'=>array('vorerfassunglist')),
    array('label'=>'20 Kunden auf einmal drucken/abrechnen', 'url'=>array('printsummulti','amount'=>20)),
    array('label'=>'Auszahlungsliste (für Unterschriften)', 'url'=>array('auszahlungsliste')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#kunden-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Liste aller Kunden inkls. Suche</h1>

<!--<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p> -->

<!-- darstellung einer meldung nach erfolgreichem oder eben fehlerhaftem import-->
<?php if(Yii::app()->user->hasFlash('import')): ?>
    <?php
        //wenn text error oder fehler vorkommt -> rote meldung, sonnst grün
        $message=Yii::app()->user->getFlash('import');
        if(stristr($message,"error")!=false || stristr($message,"fehler")!=false)
        {
            echo "<div class=\"flash-error\">".$message."</div>"; 
        }
        else
        {
            echo "<div class=\"flash-success\">".$message."</div>";     
        }
        if(Yii::app()->user->hasFlash('import_notice'))
        {
            echo "<div class=\"flash-notice\">".Yii::app()->user->getFlash('import_notice')."</div>";     
        }
    ?>
<?php endif; ?>

<?php //echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'kunden-grid',
	'dataProvider'=>$model->search(),
    'template' => "{pager}{summary}\n{items}\n{pager}",
	'filter'=>$model,
	'columns'=>array(
		'KundenNr',
		'Name',
		'Telefon',
        'PLZ',
        'AbgerechnetFlag',
        'AbgerechnetTS',
        'VerwaltungBezahltFlag',
		'ImportID',
		array(                          
			'header'=> 'Kunde Ändern',
            'class'=>'CButtonColumn',   //um mehr buttons hinzuzufügen siehe anleitung http://www.yiiframework.com/wiki/106/using-cbuttoncolumn-to-customize-buttons-in-cgridview/
            'template' => '{update}',
		),
        /*array(                          
            'header'=> 'Artikelerfassung/Druck',
            'class'=>'CButtonColumn',   
            'template' => '{view}',
        ),*/
        array //dieser delete aufruf ist nicht über ajax, dadurch wird die gesamte seite und damit auch die gesamtsumme aktualisiert wenn man eine zeile löscht
        (
            'header'=>'Artikelerfassung und Druck', 
            'class'=>'CButtonColumn',
            'template'=>'{myview}',
            'buttons'=>array
            (
                'myview' => array
                (
                    'label'=>'Artikelerfassung und Druck',
                    'imageUrl'=>Yii::app()->request->baseUrl.'/images/icons/erfassung.png',
                    'url'=>'Yii::app()->createUrl("kunden/view", array("id"=>$data->KundenNr))',
                ),
            ),
        ),
        
	),
)); ?>
