<?php
/* @var $this KundenController */
/* @var $model Kunden */

$this->breadcrumbs = array(
    'Kunden' => array('index'),
    'Kunden aus Vorerfassung',
);

$this->menu = array(
    //array('label'=>'List Kunden', 'url'=>array('index')),
    //array('label'=>'Erstelle Kunden (F2)', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#kunden-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Liste aller Kunden aus der Vorerfassung</h1>

<!--<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p> -->

<?php //echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); 
?>
<div class="search-form" style="display:none">
    <?php //$this->renderPartial('_search',array('model'=>$model,)); 
    ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'kunden-grid',
    'dataProvider' => $dataprovider,
    //'template' => "{pager}{summary}\n{items}\n{pager}",
    //'filter'=>$model,
    'columns' => array(
        'id',
        'name',
        'telefon',
        'superuser',
        'anzahl_artikel',
        array(
            'header' => 'Bereits importiert',
            'value' => array($this, 'getKundeImportFlag') //function getKundeImportFlag aus kundenController
        ),
        array //dieser delete aufruf ist nicht über ajax, dadurch wird die gesamte seite und damit auch die gesamtsumme aktualisiert wenn man eine zeile löscht
        (
            'header' => 'Import Kunde und Artikel',
            'class' => 'CButtonColumn',
            'template' => '{myview}',
            'buttons' => array(
                'myview' => array(
                    'label' => 'Import Kunde, Artikel',
                    'imageUrl' => Yii::app()->request->baseUrl . '/images/icons/import.png',
                    'url' => 'Yii::app()->createUrl("kunden/vorerfassungimport", array("id"=>$data["id"]))',
                    'visible' => '$this->grid->controller->getKundeImportFlag($data) == "Nein"',
                ),
            ),
        ),

    ),
)); ?>