<?php /* @var $this Controller */ ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta name="language" content="en" />

	<!-- blueprint CSS framework -->
	<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/screen.css" media="screen, projection" />
	<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/print.css" media="print" />
	<!--[if lt IE 8]>
	<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/ie.css" media="screen, projection" />
	<![endif]-->

    <link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/main.css" />
	<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/custom_changes.css" />
	<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/form.css" />

    <?php
    //used for picture popup bei verkauf, see here https://stackoverflow.com/questions/46826278/yii2-display-image-in-pop-up-on-click-image
    $baseUrl = Yii::app()->baseUrl; 
    $cs = Yii::app()->getClientScript();
    $cs->registerScriptFile($baseUrl.'/js/lightbox.js');
    $cs->registerCssFile($baseUrl.'/css/lightbox.css');
    ?>
    
    
	<title><?php echo CHtml::encode($this->pageTitle); ?></title>
    
</head>

<body>

<div class="container" id="page">

    <div id="js_insert">
        <?php 
            //js einbinden für hotkeys
            Yii::app()->clientScript->registerScript('hotkey', "$(window).keydown( function(k){ if (k.which == 112){ window.location.href ='index.php?r=kunden/admin'; } if (k.which == 113){ window.location.href ='index.php?r=kunden/create'; } if (k.which == 120){ window.location.href ='index.php?r=artikel/admin'; } if (k.which == 121){ window.location.href ='index.php?r=artikel/create'; } });");
        ?>
        <!--https://stackoverflow.com/questions/1566595/can-i-use-multiple-versions-of-jquery-on-the-same-page-->
        
        
        
        
    </div>

    <!-- standardcontent nur dann anzeigen wenn action ungleich print* ist-->
    <?php if(!isset($this) || !isset($this->action) || !isset($this->action->id) || (substr($this->action->id,0,5)!="print" && substr($this->action->id,0,6)!="mobile" )):?>

	<!--<div id="header">
		<div id="logo"><?php //echo CHtml::encode(Yii::app()->name); ?></div>
	</div>-->
    <!-- header -->  
    

	<div id="mainmenu">
		<?php 
        $this->widget('zii.widgets.CMenu',array(
			    'items'=>array(
				    array('label'=>'Home', 'url'=>array('/site/index')),
				    /*array('label'=>'About', 'url'=>array('/site/page', 'view'=>'about')),
				    array('label'=>'Contact', 'url'=>array('/site/contact')), */
                    array('label'=>'Kunde (F1)', 'url'=>array('/kunden/admin')),
                    array('label'=>'Artikel (F9)', 'url'=>array('/artikel/admin')),
                    array('label'=>'Verkauf', 'url'=>array('/verkauf/create')),
                    /*array('label'=>'Etikettendruck', 'url'=>'_lable_print/index.php?von=1&bis=100&header='.base64_encode(Parameter::model()->findByPk("etikett_header")->Wert).''),*/
                    array('label'=>'Reklamation', 'url'=>array('/reklamation/admin')),
                    array('label'=>'Listen & Statistiken', 'url'=>array('/statistik/index')),
                    array('label'=>'Setup', 'url'=>array('/parameter/admin')),
                    array('label'=>'Mobile', 'url'=>array('/artikel/mobile'),'linkOptions' => array('target'=>'_blank')),
				    /*array('label'=>'Login', 'url'=>array('/site/login'), 'visible'=>Yii::app()->user->isGuest), */
				    array('label'=>'Logout ('.Yii::app()->user->name.')', 'url'=>array('/site/logout'), 'visible'=>!Yii::app()->user->isGuest)
			    ),
		    ));
        ?>
	</div><!-- mainmenu -->
	<?php if(isset($this->breadcrumbs)):?>
		<?php $this->widget('zii.widgets.CBreadcrumbs', array(
			'links'=>$this->breadcrumbs,
		)); ?><!-- breadcrumbs -->
	<?php endif?>

	<?php echo $content; ?>

	<div class="clear"></div>

	<div id="footer">
		Copyright &copy; <?php echo date('Y'); ?> by Maximilian Hehenwarter.<br/>
		Download & Information <a href="http://tauschmarkt.schlucht.at" target="blank">http://tauschmarkt.schlucht.at</a><br/>
		<?php echo Yii::powered(); ?>
	</div><!-- footer -->
    
    <?php else:?>
        <!-- zeige nur content bei ausdruck-->
        <?php echo $content; ?>
    
    <?php endif?>
    
    

</div><!-- page -->

</body>
</html>
