<?php
/* @var $this ParameterController */
/* @var $model Parameter */
/* @var $form CActiveForm */
?>

<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'parameter-form',
	// Please note: When you enable ajax validation, make sure the corresponding
	// controller action is handling ajax validation correctly.
	// There is a call to performAjaxValidation() commented in generated controller code.
	// See class documentation of CActiveForm for details on this.
	'enableAjaxValidation'=>false,
)); ?>

	<p class="note">Fields with <span class="required">*</span> are required.</p>

	<?php echo $form->errorSummary($model); ?>

    <?php if($model->isNewRecord): ?>
	    <div class="row">
		    <?php echo $form->labelEx($model,'Name'); ?>
		    <?php echo $form->textField($model,'Name',array('size'=>50,'maxlength'=>50)); ?>
		    <?php echo $form->error($model,'Name'); ?>
	    </div>
        
        <div class="row">
            <?php echo $form->labelEx($model,'Beschreibung'); ?>
            <?php echo $form->textArea($model,'Beschreibung',array('size'=>60,'maxlength'=>300,'rows'=>3, 'cols'=>50)); ?>
            <?php echo $form->error($model,'Beschreibung'); ?>
        </div>

	    <div class="row">
		    <?php echo $form->labelEx($model,'Wert'); ?>
		    <?php echo $form->textArea($model,'Wert',array('rows'=>6, 'cols'=>50)); ?>
		    <?php echo $form->error($model,'Wert'); ?>
	    </div>

	    <div class="row">
		    <?php echo $form->labelEx($model,'Laenge'); ?>
		    <?php echo $form->textField($model,'Laenge'); ?>
		    <?php echo $form->error($model,'Laenge'); ?>
	    </div>
        
        <?php
            $option_list['text']='text';
            $option_list['zahl_1-99']='zahl_1-99';
            $option_list['ganzzahl']='ganzzahl';
            $option_list['float_0-10']='float_0-10';
            $option_list['bool']='bool';
            $option_list['dd.mm.YYYY_HH:mm:ss']='dd.mm.yyyy_hh:mm:ss';
        ?>
	    <div class="row">
		    <?php echo $form->labelEx($model,'Typ'); ?>
		    <?php //echo $form->textField($model,'Typ',array('size'=>10,'maxlength'=>10)); ?>
            <?php echo $form->dropDownList($model,'Typ', $option_list); ?>
		    <?php echo $form->error($model,'Typ'); ?>
	    </div>
	    
    <?php else: ?>
        <div class="row">
            <?php echo $form->labelEx($model,'Beschreibung'); ?>
            <?php echo $form->textArea($model,'Beschreibung',array('size'=>60,'maxlength'=>300,'disabled'=>'true','rows'=>3, 'cols'=>50)); ?>
            <?php echo $form->error($model,'Beschreibung'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model,'Typ'); ?>
            <?php echo $form->textField($model,'Typ',array('size'=>30,'maxlength'=>20,'disabled'=>'true')); ?>
            <?php echo $form->error($model,'Typ'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model,'Laenge'); ?>
            <?php echo $form->textField($model,'Laenge',array('disabled'=>'true')); ?>
            <?php echo $form->error($model,'Laenge'); ?>
        </div>
        <div class="row">
            <?php echo $form->labelEx($model,'Wert'); ?>
            <?php echo $form->textArea($model,'Wert',array('rows'=>6, 'cols'=>50)); ?>
            <?php echo $form->error($model,'Wert'); ?>
        </div>
    <?php endif; ?>
    

	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
	</div>

<?php $this->endWidget(); ?>

</div><!-- form -->