<?php
/* @var $this ReklamationController */
/* @var $model Reklamation */

$this->breadcrumbs=array(
	'Reklamation'=>array('admin')
);

$this->menu=array(
	//array('label'=>'List Reklamation', 'url'=>array('index')),
	array('label'=>'Erstelle Reklamation', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#reklamation-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Liste der Reklamationen</h1>

Hier können neben Kundenreklamationen auch jene Artikel erfasst werden, bei denen es zu Problemen durch Etikettablösung und ähnlichem gekommen ist.


<?php //echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'reklamation-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'ReklamationNr',
		/*'RefKundenNr',*/
        array(            
            'name'=>'RefKundenNr',
            'header'=>'Kunde',
            'value'=> array($this,'getKundenName') //function getArtikelName aus ReklamationsController
        ),
		'RefArtikelNr',
        array(            
            'name'=>'RefArtikelNr',
            'header'=>'ArtikelName',
            'value'=> array($this,'getArtikelName') //function getArtikelName aus ReklamationsController
        ),
		/*'Beschwerde',
		'AngedachteLoesung',*/
		'Status',
		'ErfassungTS',
		/*array(
			'class'=>'CButtonColumn',
		), */
        array(
            'header'=> 'Anschauen/Ändern',
            'class'=>'CButtonColumn',
            'template' => '{update}',
        ),
        /*array(
            'header'=> 'Löschen',
            'class'=>'CButtonColumn',
            'template' => '{delete}',
        ),*/
        array //dieser delete aufruf ist nicht über ajax, dadurch wird die gesamte seite und damit auch die gesamtsumme aktualisiert wenn man eine zeile löscht
        (
            'header'=>'Löschen', 
            'class'=>'CButtonColumn',
            'template'=>'{mydelete}',
            'buttons'=>array
            (
                'mydelete' => array
                (
                    'label'=>'Löschen',
                    'imageUrl'=>Yii::app()->request->baseUrl.'/images/icons/mydelete.png',
                    'url'=>'Yii::app()->createUrl("reklamation/delete", array("id"=>$data->ReklamationNr))',
                    'options' => array (
                            'confirm' => 'Position stornieren ?',
                    )
                ),
            ),
        ),
	),
)); ?>
