<?php
/* @var $this VerkaufController */
/* @var $model Verkauf */

$this->breadcrumbs=array(
	'Verkaufsübersicht',
);

$this->menu=array(
	//array('label'=>'List Verkauf', 'url'=>array('index')),
	//array('label'=>'Verkauf', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#verkauf-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Verkaufsübersicht</h1>

<!--
<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>-->

<?php //echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'verkauf-grid',
	'dataProvider'=>$model->search(),
    'template' => "{pager}{summary}\n{items}\n{pager}",
	'filter'=>$model,
	'columns'=>array(
		'ID',
		'SessionID',
		'ErfassterBarcode',
		'RefArtikelNr',
		'ErfassungTS',
		'VerkaufErledigt',
        array(            
            'header'=>'ArtName',
            'value'=> array($this,'getArtikelName') //function getArtikelName aus verkaufController
        ),
        array(            
            'header'=>'Preis',
            'value'=> array($this,'getArtikelPreis') //function getArtikelPreis aus verkaufController
        ),
		/*array(
			'class'=>'CButtonColumn',
		), */
	),
)); ?>
