<?php
/* @var $this WarengruppeController */
/* @var $model Warengruppe */

$this->breadcrumbs=array(
	'Warengruppen'=>array('admin')
);

$this->menu=array(
    array('label'=>'Erstelle Warengruppe', 'url'=>array('create')),
    array('label'=>'Warengruppe an Vorerfassung übertragen', 'url'=>array('exportvorerfassung')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#warengruppe-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Liste aller Warengruppen</h1>

<!-- darstellung einer meldung nach erfolgreichem oder eben fehlerhaftem export-->
<?php if(Yii::app()->user->hasFlash('export')): ?>
    <?php
        //wenn text error oder fehler vorkommt -> rote meldung, sonnst grün
        $message=Yii::app()->user->getFlash('export');
        if(stristr($message,"error")!=false || stristr($message,"fehler")!=false)
        {
            echo "<div class=\"flash-error\">".$message."</div>"; 
        }
        else
        {
            echo "<div class=\"flash-success\">".$message."</div>";     
        }
    ?>
<?php endif; ?>

<?php //echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'warengruppe-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'ID',
		'Name',
		array(
			'header'=>'Ändern',
            'class'=>'CButtonColumn',
            'template' => '{update}',
		),
        array //dieser delete aufruf ist nicht über ajax, dadurch wird die gesamte seite und damit auch die gesamtsumme aktualisiert wenn man eine zeile löscht
        (
            'header'=>'Löschen', 
            'class'=>'CButtonColumn',
            'template'=>'{mydelete}',
            'buttons'=>array
            (
                'mydelete' => array
                (
                    'label'=>'Löschen',
                    'imageUrl'=>Yii::app()->request->baseUrl.'/images/icons/mydelete.png',
                    'url'=>'Yii::app()->createUrl("warengruppe/delete", array("id"=>$data->ID))',
                    'options' => array (
                            'confirm' => 'Position stornieren ?',
                    )
                ),
            ),
        ),
	),
)); ?>
